/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.task.progress.interval;

import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.interval.Interval;

public class PipeCommitInterval
extends Interval<PipeCommitInterval> {
    private ProgressIndex currentIndex;
    private List<Runnable> onCommittedHooks;
    private final PipeTaskMeta pipeTaskMeta;

    public PipeCommitInterval(long start, long end, ProgressIndex currentIndex, List<Runnable> onCommittedHooks, PipeTaskMeta pipeTaskMeta) {
        super(start, end);
        this.pipeTaskMeta = pipeTaskMeta;
        this.currentIndex = Objects.nonNull(currentIndex) ? currentIndex : MinimumProgressIndex.INSTANCE;
        this.onCommittedHooks = onCommittedHooks;
    }

    @Override
    public void onMerged(PipeCommitInterval another) {
        this.currentIndex = this.currentIndex.updateToMinimumEqualOrIsAfterProgressIndex(another.currentIndex);
        if (this.start <= another.start) {
            this.onCommittedHooks.addAll(another.onCommittedHooks);
        } else {
            another.onCommittedHooks.addAll(this.onCommittedHooks);
            this.onCommittedHooks = another.onCommittedHooks;
        }
    }

    @Override
    public void onRemoved() {
        if (Objects.nonNull(this.pipeTaskMeta)) {
            this.pipeTaskMeta.updateProgressIndex(this.currentIndex);
        }
        this.onCommittedHooks.forEach(Runnable::run);
    }

    @Override
    public String toString() {
        return "PipeCommitInterval{progressIndex='" + this.currentIndex + "', range=" + super.toString() + "}";
    }
}

