/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.analyze.TemplatedInfo;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class TypeProvider {
    private final Map<String, TSDataType> typeMap;
    private TemplatedInfo templatedInfo;

    public TypeProvider() {
        this.typeMap = new HashMap<String, TSDataType>();
    }

    public TypeProvider(Map<String, TSDataType> typeMap, TemplatedInfo templatedInfo) {
        this.typeMap = typeMap;
        this.templatedInfo = templatedInfo;
        this.typeMap.putIfAbsent("Time", TSDataType.INT64);
    }

    public TSDataType getType(String symbol) {
        TSDataType type = this.typeMap.get(symbol);
        if (this.templatedInfo == null || type != null) {
            return type;
        }
        IMeasurementSchema schema = this.templatedInfo.getSchemaMap().get(symbol);
        return schema == null ? null : schema.getType();
    }

    public void setType(String symbol, TSDataType dataType) {
        if (dataType != null) {
            this.typeMap.put(symbol, dataType);
        }
    }

    public Map<String, TSDataType> getTypeMap() {
        return this.typeMap;
    }

    public void setTemplatedInfo(TemplatedInfo templatedInfo) {
        this.templatedInfo = templatedInfo;
    }

    public TemplatedInfo getTemplatedInfo() {
        return this.templatedInfo;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.typeMap.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry<String, TSDataType> entry : this.typeMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((int)entry.getValue().ordinal(), (ByteBuffer)byteBuffer);
        }
        if (this.templatedInfo == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.templatedInfo.serialize(byteBuffer);
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.typeMap.size(), (OutputStream)stream);
        for (Map.Entry<String, TSDataType> entry : this.typeMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)stream);
            ReadWriteIOUtils.write((int)entry.getValue().ordinal(), (OutputStream)stream);
        }
        if (this.templatedInfo == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.templatedInfo.serialize(stream);
        }
    }

    public static TypeProvider deserialize(ByteBuffer byteBuffer) {
        HashMap<String, TSDataType> typeMap = new HashMap<String, TSDataType>();
        for (int mapSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); mapSize > 0; --mapSize) {
            typeMap.put(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), TSDataType.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)]);
        }
        TemplatedInfo templatedInfo = null;
        byte hasTemplatedInfo = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        if (hasTemplatedInfo == 1) {
            templatedInfo = TemplatedInfo.deserialize(byteBuffer);
        }
        return new TypeProvider(typeMap, templatedInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeProvider that = (TypeProvider)o;
        return Objects.equals(this.typeMap, that.typeMap);
    }

    public int hashCode() {
        return Objects.hash(this.typeMap);
    }
}

