/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression.ArithmeticOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression.BinaryComputation;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression.ComparisonOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression.ConstantComputation;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression.LogicalOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression.NaryComputation;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression.ReferenceComputation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.ExpressionAndValuePointers;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DoubleLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StringLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;

public abstract class Computation {
    public abstract Object evaluate(List<Object> var1);

    public static class ComputationParser {
        public static Computation parse(ExpressionAndValuePointers expressionAndValuePointers) {
            Expression expression = expressionAndValuePointers.getExpression();
            List<ExpressionAndValuePointers.Assignment> assignments = expressionAndValuePointers.getAssignments();
            AtomicInteger counter = new AtomicInteger(0);
            HashMap<String, Integer> symbolToIndex = new HashMap<String, Integer>();
            for (int i = 0; i < assignments.size(); ++i) {
                symbolToIndex.put(assignments.get(i).getSymbol().getName(), i);
            }
            return ComputationParser.parse(expression, counter, symbolToIndex);
        }

        private static Computation parse(Expression expression, AtomicInteger counter, Map<String, Integer> symbolToIndex) {
            if (expression instanceof ArithmeticBinaryExpression) {
                ArithmeticBinaryExpression arithmeticExpr = (ArithmeticBinaryExpression)expression;
                Computation left = ComputationParser.parse(arithmeticExpr.getLeft(), counter, symbolToIndex);
                Computation right = ComputationParser.parse(arithmeticExpr.getRight(), counter, symbolToIndex);
                ArithmeticOperator op = ComputationParser.mapArithmeticOperator(arithmeticExpr.getOperator());
                return new BinaryComputation(left, right, op);
            }
            if (expression instanceof ComparisonExpression) {
                ComparisonExpression comparisonExpr = (ComparisonExpression)expression;
                Computation left = ComputationParser.parse(comparisonExpr.getLeft(), counter, symbolToIndex);
                Computation right = ComputationParser.parse(comparisonExpr.getRight(), counter, symbolToIndex);
                ComparisonOperator op = ComputationParser.mapComparisonOperator(comparisonExpr.getOperator());
                return new BinaryComputation(left, right, op);
            }
            if (expression instanceof LogicalExpression) {
                LogicalExpression logicalExpr = (LogicalExpression)expression;
                ArrayList<Computation> computations = new ArrayList<Computation>();
                for (Expression term : logicalExpr.getTerms()) {
                    computations.add(ComputationParser.parse(term, counter, symbolToIndex));
                }
                LogicalOperator op = ComputationParser.mapLogicalOperator(logicalExpr.getOperator());
                return new NaryComputation(computations, op);
            }
            if (expression instanceof SymbolReference) {
                SymbolReference symRef = (SymbolReference)expression;
                String name = symRef.getName();
                int index = symbolToIndex.get(name);
                return new ReferenceComputation(index);
            }
            if (expression instanceof LongLiteral) {
                LongLiteral constExpr = (LongLiteral)expression;
                return new ConstantComputation(constExpr.getParsedValue());
            }
            if (expression instanceof DoubleLiteral) {
                DoubleLiteral constExpr = (DoubleLiteral)expression;
                return new ConstantComputation(constExpr.getValue());
            }
            if (expression instanceof StringLiteral) {
                StringLiteral constExpr = (StringLiteral)expression;
                return new ConstantComputation(constExpr.getValue());
            }
            if (expression instanceof BooleanLiteral) {
                BooleanLiteral constExpr = (BooleanLiteral)expression;
                return new ConstantComputation(constExpr.getValue());
            }
            throw new SemanticException("Unsupported expression type: " + expression.getClass().getName());
        }

        private static ArithmeticOperator mapArithmeticOperator(ArithmeticBinaryExpression.Operator operator) {
            switch (operator) {
                case ADD: {
                    return ArithmeticOperator.ADD;
                }
                case SUBTRACT: {
                    return ArithmeticOperator.SUBTRACT;
                }
                case MULTIPLY: {
                    return ArithmeticOperator.MULTIPLY;
                }
                case DIVIDE: {
                    return ArithmeticOperator.DIVIDE;
                }
                case MODULUS: {
                    return ArithmeticOperator.MODULUS;
                }
            }
            throw new SemanticException("Unsupported arithmetic operator: " + (Object)((Object)operator));
        }

        private static ComparisonOperator mapComparisonOperator(ComparisonExpression.Operator operator) {
            switch (operator) {
                case LESS_THAN: {
                    return ComparisonOperator.LESS_THAN;
                }
                case GREATER_THAN: {
                    return ComparisonOperator.GREATER_THAN;
                }
                case EQUAL: {
                    return ComparisonOperator.EQUAL;
                }
                case NOT_EQUAL: {
                    return ComparisonOperator.NOT_EQUAL;
                }
                case LESS_THAN_OR_EQUAL: {
                    return ComparisonOperator.LESS_THAN_OR_EQUAL;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return ComparisonOperator.GREATER_THAN_OR_EQUAL;
                }
                case IS_DISTINCT_FROM: {
                    return ComparisonOperator.IS_DISTINCT_FROM;
                }
            }
            throw new SemanticException("Unsupported comparison operator: " + (Object)((Object)operator));
        }

        private static LogicalOperator mapLogicalOperator(LogicalExpression.Operator operator) {
            switch (operator) {
                case AND: {
                    return LogicalOperator.AND;
                }
                case OR: {
                    return LogicalOperator.OR;
                }
            }
            throw new SemanticException("Unsupported logical operator: " + (Object)((Object)operator));
        }
    }
}

