/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.spring.cloud.zuul.tracing;

import brave.Tracer;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.lang.invoke.MethodHandles;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TracePostZuulFilter
extends ZuulFilter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Tracer tracer;
    private final HttpClientHandler<RequestContext, HttpServletResponse> clientHandler;

    TracePostZuulFilter(HttpTracing tracer, HttpClientHandler<RequestContext, HttpServletResponse> clientHandler) {
        this.tracer = tracer.tracing().tracer();
        this.clientHandler = clientHandler;
    }

    public boolean shouldFilter() {
        return this.tracer.currentSpan() != null;
    }

    public Object run() {
        RequestContext context = RequestContext.getCurrentContext();
        ((Tracer.SpanInScope)context.getRequest().getAttribute(Tracer.SpanInScope.class.getName())).close();
        this.clientHandler.handleReceive((Object)context.getResponse(), null, this.tracer.currentSpan());
        log.debug("Closed span {} for {}", (Object)this.tracer.currentSpan(), (Object)context.getRequest().getMethod());
        return null;
    }

    public String filterType() {
        return "post";
    }

    public int filterOrder() {
        return 0;
    }
}

