/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public final class FastHttpDateFormat {
    private static final int CACHE_SIZE = Integer.parseInt(System.getProperty("org.apache.tomcat.util.http.FastHttpDateFormat.CACHE_SIZE", "1000"));
    public static final String RFC1123_DATE = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private static final TimeZone gmtZone = TimeZone.getTimeZone("GMT");
    private static volatile long currentDateGenerated;
    private static String currentDate;
    private static final Map<Long, String> formatCache;
    private static final Map<String, Long> parseCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getCurrentDate() {
        long now = System.currentTimeMillis();
        if (now - currentDateGenerated > 1000L) {
            SimpleDateFormat simpleDateFormat = format;
            synchronized (simpleDateFormat) {
                if (now - currentDateGenerated > 1000L) {
                    currentDate = format.format(new Date(now));
                    currentDateGenerated = now;
                }
            }
        }
        return currentDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String formatDate(long value, DateFormat threadLocalformat) {
        Long longValue = value;
        String cachedDate = formatCache.get(longValue);
        if (cachedDate != null) {
            return cachedDate;
        }
        String newDate = null;
        Date dateValue = new Date(value);
        if (threadLocalformat != null) {
            newDate = threadLocalformat.format(dateValue);
            FastHttpDateFormat.updateFormatCache(longValue, newDate);
        } else {
            SimpleDateFormat simpleDateFormat = format;
            synchronized (simpleDateFormat) {
                newDate = format.format(dateValue);
            }
            FastHttpDateFormat.updateFormatCache(longValue, newDate);
        }
        return newDate;
    }

    public static final long parseDate(String value, DateFormat[] threadLocalformats) {
        Long cachedDate = parseCache.get(value);
        if (cachedDate != null) {
            return cachedDate;
        }
        Long date = null;
        if (threadLocalformats == null) {
            throw new IllegalArgumentException();
        }
        date = FastHttpDateFormat.internalParseDate(value, threadLocalformats);
        FastHttpDateFormat.updateParseCache(value, date);
        if (date == null) {
            return -1L;
        }
        return date;
    }

    private static final Long internalParseDate(String value, DateFormat[] formats) {
        Date date = null;
        for (int i = 0; date == null && i < formats.length; ++i) {
            try {
                date = formats[i].parse(value);
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    private static void updateFormatCache(Long key, String value) {
        if (value == null) {
            return;
        }
        if (formatCache.size() > CACHE_SIZE) {
            formatCache.clear();
        }
        formatCache.put(key, value);
    }

    private static void updateParseCache(String key, Long value) {
        if (value == null) {
            return;
        }
        if (parseCache.size() > CACHE_SIZE) {
            parseCache.clear();
        }
        parseCache.put(key, value);
    }

    static {
        format.setTimeZone(gmtZone);
        currentDateGenerated = 0L;
        currentDate = null;
        formatCache = new ConcurrentHashMap<Long, String>(CACHE_SIZE);
        parseCache = new ConcurrentHashMap<String, Long>(CACHE_SIZE);
    }
}

