/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.metrics.servo;

import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.BasicDistributionSummary;
import com.netflix.servo.monitor.BasicTimer;
import com.netflix.servo.monitor.DoubleGauge;
import com.netflix.servo.monitor.LongGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;

public class ServoMetricServices
implements CounterService,
GaugeService {
    private final MonitorRegistry registry;
    private final ConcurrentMap<String, BasicCounter> counters = new ConcurrentHashMap<String, BasicCounter>();
    private final ConcurrentMap<String, LongGauge> longGauges = new ConcurrentHashMap<String, LongGauge>();
    private final ConcurrentMap<String, DoubleGauge> doubleGauges = new ConcurrentHashMap<String, DoubleGauge>();
    private final ConcurrentMap<String, BasicDistributionSummary> distributionSummaries = new ConcurrentHashMap<String, BasicDistributionSummary>();
    private final ConcurrentMap<String, BasicTimer> timers = new ConcurrentHashMap<String, BasicTimer>();

    public ServoMetricServices(MonitorRegistry registry) {
        this.registry = registry;
    }

    protected static String stripMetricName(String metricName) {
        return metricName.replaceFirst("^(timer|histogram|meter)\\.", "");
    }

    public void increment(String name) {
        this.incrementInternal(name, 1L);
    }

    public void decrement(String name) {
        this.incrementInternal(name, -1L);
    }

    private void incrementInternal(String name, long value) {
        String strippedName = ServoMetricServices.stripMetricName(name);
        if (!name.startsWith("status.")) {
            if (name.startsWith("meter.")) {
                BasicCounter counter = (BasicCounter)this.counters.get(strippedName);
                if (counter == null) {
                    counter = new BasicCounter(MonitorConfig.builder((String)strippedName).build());
                    this.counters.put(strippedName, counter);
                    this.registry.register((Monitor)counter);
                }
                counter.increment(value);
            } else {
                LongGauge gauge = (LongGauge)this.longGauges.get(strippedName);
                if (gauge == null) {
                    gauge = new LongGauge(MonitorConfig.builder((String)strippedName).build());
                    this.longGauges.put(strippedName, gauge);
                    this.registry.register((Monitor)gauge);
                }
                gauge.set(Long.valueOf(value));
            }
        }
    }

    public void reset(String name) {
        BasicDistributionSummary distributionSummary;
        LongGauge gauge;
        String strippedName = ServoMetricServices.stripMetricName(name);
        BasicCounter counter = (BasicCounter)this.counters.remove(strippedName);
        if (counter != null) {
            this.registry.unregister((Monitor)counter);
        }
        if ((gauge = (LongGauge)this.longGauges.remove(strippedName)) != null) {
            this.registry.unregister((Monitor)gauge);
        }
        if ((distributionSummary = (BasicDistributionSummary)this.distributionSummaries.remove(strippedName)) != null) {
            this.registry.unregister((Monitor)distributionSummary);
        }
    }

    public void submit(String name, double dValue) {
        long value = Double.valueOf(dValue).longValue();
        String strippedName = ServoMetricServices.stripMetricName(name);
        if (name.startsWith("histogram.")) {
            BasicDistributionSummary distributionSummary = (BasicDistributionSummary)this.distributionSummaries.get(strippedName);
            if (distributionSummary == null) {
                distributionSummary = new BasicDistributionSummary(MonitorConfig.builder((String)strippedName).build());
                this.distributionSummaries.put(strippedName, distributionSummary);
                this.registry.register((Monitor)distributionSummary);
            }
            distributionSummary.record(value);
        } else if (name.startsWith("timer.")) {
            BasicTimer timer = (BasicTimer)this.timers.get(strippedName);
            if (timer == null) {
                timer = new BasicTimer(MonitorConfig.builder((String)strippedName).build());
                this.timers.put(strippedName, timer);
                this.registry.register((Monitor)timer);
            }
            timer.record(value, TimeUnit.MILLISECONDS);
        } else {
            DoubleGauge gauge = (DoubleGauge)this.doubleGauges.get(strippedName);
            if (gauge == null) {
                gauge = new DoubleGauge(MonitorConfig.builder((String)strippedName).build());
                this.doubleGauges.put(strippedName, gauge);
                this.registry.register((Monitor)gauge);
            }
            gauge.set(Double.valueOf(dValue));
        }
    }
}

