/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.springboot.starter.transport;

import com.netflix.config.DynamicPropertyFactory;
import java.io.IOException;
import java.net.ServerSocket;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.transport.rest.servlet.ServletConfig;
import org.apache.servicecomb.transport.rest.servlet.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.embedded.AbstractConfigurableEmbeddedServletContainer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RestServletInitializer
extends AbstractConfigurableEmbeddedServletContainer
implements ServletContextInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestServletInitializer.class);

    public void onStartup(ServletContext servletContext) throws ServletException {
        if (this.getPort() == 0) {
            LOGGER.warn("spring boot embed web container listen port is 0, serviceComb will not use container's port to handler RESTful request.");
            return;
        }
        try (ServerSocket ss = new ServerSocket(this.getPort(), 0, this.getAddress());){
            if (StringUtils.isEmpty((Object)ServletConfig.getServletUrlPattern())) {
                Configuration configuration = (Configuration)DynamicPropertyFactory.getBackingConfigurationSource();
                configuration.setProperty("servicecomb.rest.servlet.urlPattern", (Object)"/*");
            }
            ServletUtils.init((ServletContext)servletContext);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

