/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class ConditionWaiter<T> {
    private final AtomicReference<T> dataReference;
    private final AtomicBoolean isComplete;
    private final long sleepDuration;
    private final TimeUnit timeUnit;
    private final ExecutorService executorService;

    public ConditionWaiter(T initialData, long sleepDuration, TimeUnit timeUnit) {
        this.dataReference = new AtomicReference<T>(initialData);
        this.isComplete = new AtomicBoolean(false);
        this.sleepDuration = sleepDuration;
        this.timeUnit = timeUnit;
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public T waitForCompletion() {
        while (!this.isComplete.get()) {
            SleepUtil.sleep(this.sleepDuration, this.timeUnit);
        }
        return this.dataReference.get();
    }

    public void setData(T newData) {
        this.dataReference.set(newData);
    }

    public void executeTaskAsync(Callable<T> task) {
        CompletableFuture.supplyAsync(() -> {
            try {
                return task.call();
            }
            catch (Exception e) {
                throw new RuntimeException("Task execution failed", e);
            }
        }, this.executorService).thenAccept(result -> {
            this.setData(result);
            this.isComplete.set(true);
        });
    }

    public static class SleepUtil {
        public static void sleep(long duration, TimeUnit timeUnit) {
            try {
                timeUnit.sleep(duration);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                System.out.println("Thread was interrupted during sleep!");
            }
        }
    }
}

