/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.converter.property;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Map;
import org.apache.servicecomb.swagger.converter.ConverterMgr;
import org.apache.servicecomb.swagger.converter.property.AbstractPropertyConverter;

public class MapPropertyConverter
extends AbstractPropertyConverter {
    @Override
    public JavaType doConvert(OpenAPI swagger, Schema property) {
        MapSchema mapProperty = (MapSchema)property;
        Object valueProperty = mapProperty.getAdditionalProperties();
        if (valueProperty instanceof Boolean) {
            return TypeFactory.defaultInstance().constructType(Boolean.class);
        }
        return MapPropertyConverter.findJavaType(swagger, (Schema)valueProperty);
    }

    public static JavaType findJavaType(OpenAPI swagger, Schema valueProperty) {
        JavaType valueJavaType = ConverterMgr.findJavaType(swagger, valueProperty);
        return TypeFactory.defaultInstance().constructMapType(Map.class, STRING_JAVA_TYPE, valueJavaType);
    }
}

