/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.Collections;
import java.util.Map;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.core.provider.OpenAPIRegistry;
import org.apache.servicecomb.core.provider.OpenAPIRegistryManager;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class LocalOpenAPIRegistry
implements OpenAPIRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalOpenAPIRegistry.class);
    private final Map<String, Map<String, Map<String, OpenAPI>>> apps = new ConcurrentHashMapEx();
    private final Environment environment;
    private OpenAPIRegistryManager.OpenAPIChangeListener openAPIChangeListener;

    public LocalOpenAPIRegistry(Environment environment) {
        this.environment = environment;
    }

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public void registerOpenAPI(String application, String serviceName, String schemaId, OpenAPI api) {
        this.apps.computeIfAbsent(application, k -> new ConcurrentHashMapEx()).computeIfAbsent(serviceName, k -> new ConcurrentHashMapEx()).put(schemaId, api);
        this.openAPIChangeListener.onOpenAPIChanged(application, serviceName);
        LOGGER.info("register swagger appId={}, name={}, schemaId={}.", new Object[]{application, serviceName, schemaId});
    }

    public Map<String, OpenAPI> loadOpenAPI() {
        return this.loadOpenAPI(BootStrapProperties.readApplication((Environment)this.environment), BootStrapProperties.readServiceName((Environment)this.environment));
    }

    @Override
    public Map<String, OpenAPI> loadOpenAPI(String application, String serviceName) {
        if (this.apps.get(application) != null && this.apps.get(application).get(serviceName) != null) {
            return this.apps.get(application).get(serviceName);
        }
        return Collections.emptyMap();
    }

    @Override
    public void setOpenAPIChangeListener(OpenAPIRegistryManager.OpenAPIChangeListener listener) {
        this.openAPIChangeListener = listener;
    }

    public int getOrder() {
        return -10000;
    }
}

