/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SoftProcess;
import com.sun.media.sound.SoftSynthesizer;

public class SoftLowFrequencyOscillator
implements SoftProcess {
    private int max_count = 10;
    private int used_count = 0;
    private double[][] out = new double[this.max_count][1];
    private double[][] delay = new double[this.max_count][1];
    private double[][] delay2 = new double[this.max_count][1];
    private double[][] freq = new double[this.max_count][1];
    private int[] delay_counter = new int[this.max_count];
    private double[] sin_phase = new double[this.max_count];
    private double[] sin_stepfreq = new double[this.max_count];
    private double[] sin_step = new double[this.max_count];
    private double control_time = 0.0;
    private double sin_factor = 0.0;
    private static double PI2 = Math.PI * 2;

    public SoftLowFrequencyOscillator() {
        for (int i = 0; i < this.sin_stepfreq.length; ++i) {
            this.sin_stepfreq[i] = Double.NEGATIVE_INFINITY;
        }
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.used_count; ++i) {
            this.out[i][0] = 0.0;
            this.delay[i][0] = 0.0;
            this.delay2[i][0] = 0.0;
            this.freq[i][0] = 0.0;
            this.delay_counter[i] = 0;
            this.sin_phase[i] = 0.0;
            this.sin_stepfreq[i] = Double.NEGATIVE_INFINITY;
            this.sin_step[i] = 0.0;
        }
        this.used_count = 0;
    }

    @Override
    public void init(SoftSynthesizer softSynthesizer) {
        this.control_time = 1.0 / (double)softSynthesizer.getControlRate();
        this.sin_factor = this.control_time * 2.0 * Math.PI;
        for (int i = 0; i < this.used_count; ++i) {
            this.delay_counter[i] = (int)(Math.pow(2.0, this.delay[i][0] / 1200.0) / this.control_time);
            int n = i;
            this.delay_counter[n] = this.delay_counter[n] + (int)(this.delay2[i][0] / (this.control_time * 1000.0));
        }
        this.processControlLogic();
    }

    @Override
    public void processControlLogic() {
        for (int i = 0; i < this.used_count; ++i) {
            double d;
            if (this.delay_counter[i] > 0) {
                int n = i;
                this.delay_counter[n] = this.delay_counter[n] - 1;
                this.out[i][0] = 0.5;
                continue;
            }
            double d2 = this.freq[i][0];
            if (this.sin_stepfreq[i] != d2) {
                this.sin_stepfreq[i] = d2;
                d = 440.0 * Math.exp((d2 - 6900.0) * (Math.log(2.0) / 1200.0));
                this.sin_step[i] = d * this.sin_factor;
            }
            d = this.sin_phase[i];
            d += this.sin_step[i];
            while (d > PI2) {
                d -= PI2;
            }
            this.out[i][0] = 0.5 + Math.sin(d) * 0.5;
            this.sin_phase[i] = d;
        }
    }

    @Override
    public double[] get(int n, String string) {
        if (n >= this.used_count) {
            this.used_count = n + 1;
        }
        if (string == null) {
            return this.out[n];
        }
        if (string.equals("delay")) {
            return this.delay[n];
        }
        if (string.equals("delay2")) {
            return this.delay2[n];
        }
        if (string.equals("freq")) {
            return this.freq[n];
        }
        return null;
    }
}

