/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xml.internal.serializer.Encodings;
import com.sun.org.apache.xml.internal.serializer.utils.Utils;
import com.sun.org.apache.xml.internal.serializer.utils.WrappedRuntimeException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Properties;

public final class OutputPropertiesFactory {
    private static final String S_BUILTIN_EXTENSIONS_URL = "http://xml.apache.org/xalan";
    private static final String S_BUILTIN_OLD_EXTENSIONS_URL = "http://xml.apache.org/xslt";
    public static final String S_BUILTIN_EXTENSIONS_UNIVERSAL = "{http://xml.apache.org/xalan}";
    public static final String S_KEY_INDENT_AMOUNT = "{http://xml.apache.org/xalan}indent-amount";
    public static final String S_KEY_LINE_SEPARATOR = "{http://xml.apache.org/xalan}line-separator";
    public static final String S_KEY_CONTENT_HANDLER = "{http://xml.apache.org/xalan}content-handler";
    public static final String S_KEY_ENTITIES = "{http://xml.apache.org/xalan}entities";
    public static final String S_USE_URL_ESCAPING = "{http://xml.apache.org/xalan}use-url-escaping";
    public static final String S_OMIT_META_TAG = "{http://xml.apache.org/xalan}omit-meta-tag";
    public static final String S_BUILTIN_OLD_EXTENSIONS_UNIVERSAL = "{http://xml.apache.org/xslt}";
    public static final int S_BUILTIN_OLD_EXTENSIONS_UNIVERSAL_LEN = "{http://xml.apache.org/xslt}".length();
    public static final String ORACLE_IS_STANDALONE = "http://www.oracle.com/xml/is-standalone";
    private static final String S_XSLT_PREFIX = "xslt.output.";
    private static final int S_XSLT_PREFIX_LEN = "xslt.output.".length();
    private static final String S_XALAN_PREFIX = "org.apache.xslt.";
    private static final int S_XALAN_PREFIX_LEN = "org.apache.xslt.".length();
    private static Integer m_synch_object = new Integer(1);
    private static final String PROP_DIR = "com/sun/org/apache/xml/internal/serializer/";
    private static final String PROP_FILE_XML = "output_xml.properties";
    private static final String PROP_FILE_TEXT = "output_text.properties";
    private static final String PROP_FILE_HTML = "output_html.properties";
    private static final String PROP_FILE_UNKNOWN = "output_unknown.properties";
    private static Properties m_xml_properties = null;
    private static Properties m_html_properties = null;
    private static Properties m_text_properties = null;
    private static Properties m_unknown_properties = null;
    private static final Class ACCESS_CONTROLLER_CLASS = OutputPropertiesFactory.findAccessControllerClass();

    private static Class findAccessControllerClass() {
        try {
            return Class.forName("java.security.AccessController");
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Properties getDefaultMethodProperties(String string) {
        String string2 = null;
        Properties properties = null;
        try {
            Object object = m_synch_object;
            synchronized (object) {
                if (null == m_xml_properties) {
                    string2 = PROP_FILE_XML;
                    m_xml_properties = OutputPropertiesFactory.loadPropertiesFile(string2, null);
                }
            }
            if (string.equals("xml")) {
                properties = m_xml_properties;
            } else if (string.equals("html")) {
                if (null == m_html_properties) {
                    string2 = PROP_FILE_HTML;
                    m_html_properties = OutputPropertiesFactory.loadPropertiesFile(string2, m_xml_properties);
                }
                properties = m_html_properties;
            } else if (string.equals("text")) {
                if (null == m_text_properties && null == (m_text_properties = OutputPropertiesFactory.loadPropertiesFile(string2 = PROP_FILE_TEXT, m_xml_properties)).getProperty("encoding")) {
                    object = Encodings.getMimeEncoding(null);
                    m_text_properties.put("encoding", object);
                }
                properties = m_text_properties;
            } else if (string.equals("")) {
                if (null == m_unknown_properties) {
                    string2 = PROP_FILE_UNKNOWN;
                    m_unknown_properties = OutputPropertiesFactory.loadPropertiesFile(string2, m_xml_properties);
                }
                properties = m_unknown_properties;
            } else {
                properties = m_xml_properties;
            }
        }
        catch (IOException iOException) {
            throw new WrappedRuntimeException(Utils.messages.createMessage("ER_COULD_NOT_LOAD_METHOD_PROPERTY", new Object[]{string2, string}), iOException);
        }
        return new Properties(properties);
    }

    private static Properties loadPropertiesFile(final String string, Properties properties) throws IOException {
        Properties properties2 = new Properties(properties);
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            inputStream = ACCESS_CONTROLLER_CLASS != null ? (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return OutputPropertiesFactory.class.getResourceAsStream(string);
                }
            }) : OutputPropertiesFactory.class.getResourceAsStream(string);
            bufferedInputStream = new BufferedInputStream(inputStream);
            properties2.load(bufferedInputStream);
        }
        catch (IOException iOException) {
            if (properties == null) {
                throw iOException;
            }
            throw new WrappedRuntimeException(Utils.messages.createMessage("ER_COULD_NOT_LOAD_RESOURCE", new Object[]{string}), iOException);
        }
        catch (SecurityException securityException) {
            if (properties == null) {
                throw securityException;
            }
            throw new WrappedRuntimeException(Utils.messages.createMessage("ER_COULD_NOT_LOAD_RESOURCE", new Object[]{string}), securityException);
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        Enumeration enumeration = ((Properties)properties2.clone()).keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = null;
            try {
                string3 = System.getProperty(string2);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string3 == null) {
                string3 = (String)properties2.get(string2);
            }
            String string4 = OutputPropertiesFactory.fixupPropertyString(string2, true);
            String string5 = null;
            try {
                string5 = System.getProperty(string4);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            string5 = string5 == null ? OutputPropertiesFactory.fixupPropertyString(string3, false) : OutputPropertiesFactory.fixupPropertyString(string5, false);
            if (string2 == string4 && string3 == string5) continue;
            properties2.remove(string2);
            properties2.put(string4, string5);
        }
        return properties2;
    }

    private static String fixupPropertyString(String string, boolean bl) {
        int n;
        if (bl && string.startsWith(S_XSLT_PREFIX)) {
            string = string.substring(S_XSLT_PREFIX_LEN);
        }
        if (string.startsWith(S_XALAN_PREFIX)) {
            string = S_BUILTIN_EXTENSIONS_UNIVERSAL + string.substring(S_XALAN_PREFIX_LEN);
        }
        if ((n = string.indexOf("\\u003a")) > 0) {
            String string2 = string.substring(n + 6);
            string = string.substring(0, n) + ":" + string2;
        }
        return string;
    }
}

