/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.cipher;

import iaik.xml.crypto.XSecProvider;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public abstract class ProxyCipher
extends CipherSpi {
    protected Cipher cipher_;

    protected abstract String getCipherName();

    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        return this.cipher_.wrap(key);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this.cipher_.update(byArray, n, n2, byArray2);
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        return this.cipher_.update(byArray, n, n2);
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws NoSuchAlgorithmException, InvalidKeyException {
        return this.cipher_.unwrap(byArray, string, n);
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.cipher_.init(n, key, algorithmParameterSpec, secureRandom);
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.cipher_.init(n, key, secureRandom);
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.cipher_.init(n, key, algorithmParameters, secureRandom);
    }

    protected AlgorithmParameters engineGetParameters() {
        return this.cipher_.getParameters();
    }

    protected int engineGetOutputSize(int n) {
        return this.cipher_.getOutputSize(n);
    }

    protected byte[] engineGetIV() {
        return this.cipher_.getIV();
    }

    protected int engineGetBlockSize() {
        return this.cipher_.getBlockSize();
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        if (byArray == null) {
            return this.cipher_.doFinal(byArray2, n3);
        }
        return this.cipher_.doFinal(byArray, n, n2, byArray2, n3);
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws BadPaddingException, IllegalBlockSizeException {
        if (byArray == null) {
            return this.cipher_.doFinal();
        }
        return this.cipher_.doFinal(byArray, n, n2);
    }

    public ProxyCipher() throws NoSuchPaddingException, NoSuchProviderException, NoSuchAlgorithmException {
        String string = this.getCipherName();
        String string2 = XSecProvider.getDelegationProvider("Cipher." + string);
        if (string2 != null) {
            try {
                this.cipher_ = Cipher.getInstance(string, string2);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new NoSuchAlgorithmException("Cipher." + string + " delegation provider '" + string2 + "' not registered.");
            }
        } else {
            this.cipher_ = Cipher.getInstance(string);
        }
    }
}

