/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.BOOLEAN;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.RDN;
import iaik.utils.InternalErrorException;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;

public class IssuingDistributionPoint
extends V3Extension {
    private boolean d = false;
    private boolean f = false;
    private int a = -1;
    private boolean c = false;
    private boolean b = false;
    private ASN1Type e;
    public static final ObjectID oid = new ObjectID("2.5.29.28", "IssuingDistributionPoint");

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.e != null) {
            stringBuffer.append("DistributionPoint: ");
            stringBuffer.append(String.valueOf(this.e.toString()) + "\n");
        }
        stringBuffer.append("onlyContainsUserCerts: " + this.b + "\n");
        stringBuffer.append("onlyContainsCaCerts: " + this.c + "\n");
        if (this.a > 0) {
            stringBuffer.append("reasonFlags: ");
            if ((this.a & 1) > 0) {
                stringBuffer.append("unused | ");
            }
            if ((this.a & 2) > 0) {
                stringBuffer.append("keyCompromise | ");
            }
            if ((this.a & 4) > 0) {
                stringBuffer.append("cACompromise | ");
            }
            if ((this.a & 8) > 0) {
                stringBuffer.append("affiliationChanged|");
            }
            if ((this.a & 0x10) > 0) {
                stringBuffer.append("superseded | ");
            }
            if ((this.a & 0x20) > 0) {
                stringBuffer.append("cessationOfOperation | ");
            }
            if ((this.a & 0x40) > 0) {
                stringBuffer.append("certificateHold | ");
            }
            stringBuffer.setLength(stringBuffer.length() - 3);
            stringBuffer.append("\n");
        }
        stringBuffer.append("indirectCRL: " + this.f + "\n");
        stringBuffer.append("onlyContainsAttributeCerts: " + this.d + "\n");
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws X509ExtensionException {
        if (this.b && this.c) {
            throw new X509ExtensionException("OnlyContainsUserCerts and OnlyContainsCaCerts are not allowed both to be true!");
        }
        boolean bl = true;
        SEQUENCE sEQUENCE = new SEQUENCE();
        try {
            if (this.e != null) {
                int n2 = -1;
                if (this.e instanceof GeneralNames) {
                    n2 = 0;
                } else if (this.e instanceof RDN) {
                    n2 = 1;
                } else {
                    throw new InternalErrorException("DistributionPointName: Unknown type [create]!");
                }
                CON_SPEC cON_SPEC = new CON_SPEC(n2, this.e.toASN1Object(), bl);
                sEQUENCE.addComponent(new CON_SPEC(0, cON_SPEC));
            }
            if (this.b) {
                sEQUENCE.addComponent(new CON_SPEC(1, new BOOLEAN(this.b), bl));
            }
            if (this.c) {
                sEQUENCE.addComponent(new CON_SPEC(2, new BOOLEAN(this.c), bl));
            }
            if (this.a != -1) {
                StringBuffer stringBuffer = new StringBuffer(Integer.toBinaryString(this.a));
                stringBuffer.reverse();
                sEQUENCE.addComponent(new CON_SPEC(3, new BIT_STRING(stringBuffer.toString()), bl));
            }
            if (this.f) {
                sEQUENCE.addComponent(new CON_SPEC(4, new BOOLEAN(this.f), bl));
            }
            if (this.d) {
                sEQUENCE.addComponent(new CON_SPEC(5, new BOOLEAN(this.d), bl));
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.getMessage());
        }
        return sEQUENCE;
    }

    public void setReasonFlags(int n2) {
        this.a = n2;
    }

    public void setOnlyContainsUserCerts(boolean bl) {
        this.b = bl;
    }

    public void setOnlyContainsCaCerts(boolean bl) {
        this.c = bl;
    }

    public void setOnlyContainsAttributeCerts(boolean bl) {
        this.d = bl;
    }

    public void setIndirectCRL(boolean bl) {
        this.f = bl;
    }

    public void setDistributionPointName(ASN1Type aSN1Type) throws IllegalArgumentException {
        if (!(aSN1Type instanceof GeneralNames) && !(aSN1Type instanceof RDN)) {
            throw new IllegalArgumentException("Only instances of GeneralNames or RDN are accepted!");
        }
        this.e = aSN1Type;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new X509ExtensionException("No DistributionPoint!");
        }
        try {
            int n2 = 0;
            while (n2 < aSN1Object.countComponents()) {
                CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(n2);
                int n3 = cON_SPEC.getAsnType().getTag();
                switch (n3) {
                    case 0: {
                        CON_SPEC cON_SPEC2 = (CON_SPEC)cON_SPEC.getValue();
                        int n4 = cON_SPEC2.getAsnType().getTag();
                        if (n4 == 0) {
                            cON_SPEC2.forceImplicitlyTagged(ASN.SEQUENCE);
                            this.e = new GeneralNames((ASN1Object)cON_SPEC2.getValue());
                            break;
                        }
                        if (n4 == 1) {
                            cON_SPEC2.forceImplicitlyTagged(ASN.SET);
                            this.e = new RDN((ASN1Object)cON_SPEC2.getValue());
                            break;
                        }
                        throw new CodingException("DistributionPointName: Unknown type [parse]!");
                    }
                    case 1: {
                        cON_SPEC.forceImplicitlyTagged(ASN.BOOLEAN);
                        BOOLEAN bOOLEAN = (BOOLEAN)cON_SPEC.getValue();
                        this.b = (Boolean)bOOLEAN.getValue();
                        break;
                    }
                    case 2: {
                        cON_SPEC.forceImplicitlyTagged(ASN.BOOLEAN);
                        BOOLEAN bOOLEAN = (BOOLEAN)cON_SPEC.getValue();
                        this.c = (Boolean)bOOLEAN.getValue();
                        break;
                    }
                    case 3: {
                        cON_SPEC.forceImplicitlyTagged(ASN.BIT_STRING);
                        BIT_STRING bIT_STRING = (BIT_STRING)cON_SPEC.getValue();
                        StringBuffer stringBuffer = new StringBuffer(bIT_STRING.getBinaryString()).reverse();
                        this.a = Integer.parseInt(stringBuffer.toString(), 2);
                        break;
                    }
                    case 4: {
                        cON_SPEC.forceImplicitlyTagged(ASN.BOOLEAN);
                        BOOLEAN bOOLEAN = (BOOLEAN)cON_SPEC.getValue();
                        this.f = (Boolean)bOOLEAN.getValue();
                        break;
                    }
                    case 5: {
                        cON_SPEC.forceImplicitlyTagged(ASN.BOOLEAN);
                        BOOLEAN bOOLEAN = (BOOLEAN)cON_SPEC.getValue();
                        this.d = (Boolean)bOOLEAN.getValue();
                        break;
                    }
                    default: {
                        throw new CodingException("Invalid issuingDistributionPoint: unsupported tag number: " + n3);
                    }
                }
                ++n2;
            }
            if (this.b && this.c) {
                throw new X509ExtensionException("OnlyContainsUserCerts and OnlyContainsCaCerts are not allowed both to be true!");
            }
        }
        catch (Exception exception) {
            throw new X509ExtensionException(exception.getMessage());
        }
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public int getReasonFlags() {
        return this.a;
    }

    public boolean getOnlyContainsUserCerts() {
        return this.b;
    }

    public boolean getOnlyContainsCaCerts() {
        return this.c;
    }

    public boolean getOnlyContainsAttributeCerts() {
        return this.d;
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public boolean getIndirectCRL() {
        return this.f;
    }

    public ASN1Type getDistributionPointName() {
        return this.e;
    }
}

