/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.Demo;
import iaik.security.ecc.ecdsa.ECDSAKeyPairGeneratorImpl;
import iaik.security.ecc.parameter.ECCParameterFactory;
import iaik.security.ecc.provider.ECCProvider;
import iaik.security.ecc.spec.ECCParameterSpec;
import iaik.security.provider.IAIK;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;

public class SimpleSignature
implements Demo {
    private static byte[] SIG_DATA;
    private static int KEY_SIZE;

    static {
        KEY_SIZE = 192;
        SIG_DATA = "Data to be signed".getBytes();
    }

    private void signAndVerify(KeyPair keyPair) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        Signature signature = Signature.getInstance("ECDSA");
        signature.initSign(keyPair.getPrivate());
        signature.update(SIG_DATA);
        byte[] byArray = signature.sign();
        signature.initVerify(keyPair.getPublic());
        signature.update(SIG_DATA);
        if (!signature.verify(byArray)) {
            System.out.println("Sig. validation failed");
            throw new RuntimeException("Sig. validation failed");
        }
        System.out.println("Sig. validation successful");
    }

    private KeyPair generateKeyPair(String string) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        ECCParameterFactory eCCParameterFactory = ECCParameterFactory.getInstance();
        ECCParameterSpec eCCParameterSpec = eCCParameterFactory.getParameterByName(string);
        ECDSAKeyPairGeneratorImpl eCDSAKeyPairGeneratorImpl = (ECDSAKeyPairGeneratorImpl)KeyPairGenerator.getInstance("ECDSA");
        eCDSAKeyPairGeneratorImpl.initialize(eCCParameterSpec);
        return eCDSAKeyPairGeneratorImpl.generateKeyPair();
    }

    private KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA");
        keyPairGenerator.initialize(KEY_SIZE);
        return keyPairGenerator.generateKeyPair();
    }

    public boolean runDemo() {
        try {
            SimpleSignature.init();
            KeyPair keyPair = this.generateKeyPair("p-192");
            this.signAndVerify(keyPair);
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static void main(String[] stringArray) {
        SimpleSignature simpleSignature = new SimpleSignature();
        if (simpleSignature.runDemo()) {
            System.out.println("FINISHED");
        } else {
            System.out.println("FAILED");
        }
    }

    public static void init() {
        IAIK.addAsJDK14Provider();
        ECCProvider.addAsProvider();
    }
}

