/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit;

import com.sun.webpane.platform.Pasteboard;
import com.sun.webpane.platform.ServiceProvider;
import com.sun.webpane.platform.graphics.WCImageFrame;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class WCPasteboard {
    private static final Logger log = Logger.getLogger(WCPasteboard.class.getName());
    private static Pasteboard pasteboard;

    private static native void initIDs();

    private WCPasteboard() {
    }

    public static String getPlainText() {
        log.fine("getPlainText()");
        return pasteboard.getPlainText();
    }

    public static String getHtml() {
        log.fine("getHtml()");
        return pasteboard.getHtml();
    }

    public static void writePlainText(String string) {
        log.log(Level.FINE, "writePlainText(): text = {0}", new Object[]{string});
        pasteboard.writePlainText(string);
    }

    public static void writeSelection(boolean bl, String string, String string2) {
        log.log(Level.FINE, "writeSelection(): canSmartCopyOrDelete = {0},\n text = \n{1}\n html=\n{2}", new Object[]{bl, string, string2});
        pasteboard.writeSelection(bl, string, string2);
    }

    public static void writeImage(WCImageFrame wCImageFrame) {
        log.log(Level.FINE, "writeImage(): img = {0}", new Object[]{wCImageFrame});
        pasteboard.writeImage(wCImageFrame);
    }

    public static void writeUrl(String string, String string2) {
        log.log(Level.FINE, "writeUrl(): url = {0}, markup = {1}", new Object[]{string, string2});
        pasteboard.writeUrl(string, string2);
    }

    public static void clear() {
        log.fine("installing dummy transferable");
    }

    static {
        WCPasteboard.initIDs();
        pasteboard = ServiceProvider.getInstance().createPasteboard();
    }
}

