/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.utilities.log4j;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConsoleUtil {
    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int WARN = 3;
    public static final int ERROR = 4;
    public static final int FATAL = 5;
    private static final Color BLUE = Display.getDefault().getSystemColor(9);
    private static final Color RED = Display.getDefault().getSystemColor(3);
    private static final Color DARK_YELLOW = Display.getDefault().getSystemColor(8);
    private static final Color BLACK = Display.getDefault().getSystemColor(2);
    public static final String VIEWID = "org.eclipse.ui.console.ConsoleView";
    private static final String CONSOLE_NAME = "RCP";

    private static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public static void logToConsole(String message, int level) {
        ConsoleUtil.logToConsole(message, level, null);
    }

    public static void logToConsole(String message, int level, Throwable ex) {
        if (PlatformUI.isWorkbenchRunning()) {
            MessageConsole myConsole = ConsoleUtil.findConsole(CONSOLE_NAME);
            MessageConsoleStream out = myConsole.newMessageStream();
            switch (level) {
                case 2: {
                    out.setColor(BLUE);
                    break;
                }
                case 1: {
                    out.setColor(BLUE);
                    break;
                }
                case 3: {
                    out.setColor(DARK_YELLOW);
                    break;
                }
                case 5: {
                    out.setColor(RED);
                    break;
                }
                case 4: {
                    out.setColor(RED);
                    break;
                }
                default: {
                    out.setColor(BLACK);
                }
            }
            out.print(String.valueOf(message) + "\n");
            if (ex != null) {
                out.setColor(RED);
                StackTraceElement[] stackTrace = ex.getStackTrace();
                out.print(String.valueOf(stackTrace[0].toString()) + "\n");
                int i = 1;
                while (i < stackTrace.length) {
                    out.print("\t" + stackTrace[i].toString() + "\n");
                    ++i;
                }
            }
            ConsoleUtil.showConsoleView(myConsole);
        }
    }

    public static void showConsoleView(MessageConsole console) {
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)console);
    }
}

