/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.net.protocol.jar;

import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.URLEncoder;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.URLUtil;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.net.www.protocol.jar.JarURLConnection;
import sun.plugin.cache.JarCacheUtil;
import sun.plugin.net.protocol.jar.Handler;

public class CachedJarURLConnection
extends JarURLConnection {
    private URL jarFileURL = null;
    private URL jarFileURLOverride = null;
    private String entryName;
    private JarEntry jarEntry;
    private JarFile jarFile;
    private String contentType;
    private boolean useJarCache = false;
    private Map headerFields = new HashMap();

    public CachedJarURLConnection(URL uRL, Handler handler) throws MalformedURLException, IOException {
        super(uRL, handler);
        this.getJarFileURL();
        this.entryName = this.getEntryName();
    }

    public synchronized URL getJarFileURL() {
        URL uRL;
        if (this.jarFile instanceof ResourceObject && (uRL = ((ResourceObject)this.jarFile).getResourceURL()) != null) {
            return uRL;
        }
        return this.getJarFileURLInternal();
    }

    private URL getJarFileURLInternal() {
        if (this.jarFileURLOverride != null) {
            return this.jarFileURLOverride;
        }
        if (this.jarFileURL == null) {
            this.jarFileURL = super.getJarFileURL();
            try {
                this.jarFileURL = new URL(URLUtil.canonicalize((String)this.jarFileURL.toString()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.jarFileURL;
    }

    public synchronized JarFile getJarFile() throws IOException {
        this.jarFile = this.getJarFileInternal();
        if (ResourceProvider.get().isInternalUse()) {
            return this.jarFile;
        }
        return JarCacheUtil.cloneJarFile(this.jarFile);
    }

    public synchronized JarFile getJarFileInternal() throws IOException {
        String string;
        if (this.jarFile != null) {
            return this.jarFile;
        }
        if (ResourceProvider.get().canCache(this.jarFileURL) && (string = (String)ToolkitStore.get().getAppContext().get((Object)("deploy-" + this.jarFileURL.toString()))) != null) {
            this.jarFileURLOverride = new URL(URLUtil.canonicalize((String)(this.jarFileURL.toString() + "?" + URLEncoder.encode((String)"version-id", (String)"UTF-8") + "=" + URLEncoder.encode((String)string, (String)"UTF-8"))));
            String string2 = ResourceProvider.get().getCurrentVersion(this.jarFileURL);
            if (string2 != null && !string2.equals(string)) {
                this.jarFileURLOverride = new URL(this.jarFileURLOverride.toString() + "&" + URLEncoder.encode((String)"current-version-id", (String)"UTF-8") + "=" + URLEncoder.encode((String)string2, (String)"UTF-8"));
            }
        }
        this.connect();
        this.jarFileURLOverride = null;
        return this.jarFile;
    }

    public JarEntry getJarEntry() throws IOException {
        this.connect();
        return this.jarEntry;
    }

    public String getHeaderField(String string) {
        String string2;
        block3: {
            string2 = null;
            try {
                this.connect();
            }
            catch (IOException iOException) {
                if (!Trace.isEnabled((TraceLevel)TraceLevel.NETWORK)) break block3;
                Trace.ignored((Throwable)iOException);
            }
        }
        List list = (List)this.headerFields.get(string);
        if (list != null) {
            string2 = (String)list.get(0);
        }
        return string2;
    }

    public void connect() throws IOException {
        if (!this.connected) {
            URL uRL = new URL(this.jarFileURL.getProtocol(), this.jarFileURL.getHost(), this.jarFileURL.getPort(), this.jarFileURL.getPath());
            if (ResourceProvider.get().canCache(uRL)) {
                String string = (String)ToolkitStore.get().getAppContext().get((Object)("deploy-" + uRL.toString()));
                this.setUseCaches(false);
                super.connect();
                URL uRL2 = string == null ? this.jarFileURL : uRL;
                Resource resource = ResourceProvider.get().getCachedResource(uRL2, string);
                this.jarFile = resource != null ? resource.getJarFile() : null;
                Map map = this.headerFields = resource != null ? resource.getHeaders() : null;
                if (this.jarFile != null) {
                    this.useJarCache = true;
                } else {
                    this.jarFile = super.getJarFile();
                }
            } else {
                super.connect();
                this.jarFile = super.getJarFile();
            }
            if (this.entryName != null) {
                this.jarEntry = this.jarFile.getJarEntry(this.entryName);
                if (this.jarEntry == null) {
                    throw new FileNotFoundException("JAR entry " + this.entryName + " not found in " + this.jarFile.getName());
                }
            }
            this.connected = true;
        }
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        if (!this.useJarCache) {
            return super.getInputStream();
        }
        InputStream inputStream = null;
        if (this.entryName == null) {
            throw new IOException("no entry name specified");
        }
        if (this.jarEntry == null) {
            throw new FileNotFoundException("JAR entry " + this.entryName + " not found in " + this.jarFile.getName());
        }
        inputStream = this.jarFile.getInputStream(this.jarEntry);
        return inputStream;
    }

    public Object getContent() throws IOException {
        Object object = null;
        this.connect();
        if (!this.useJarCache) {
            return super.getContent();
        }
        object = this.entryName == null ? this.getJarFile() : super.getContent();
        return object;
    }

    public String getContentType() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!this.useJarCache) {
            return super.getContentType();
        }
        if (this.contentType == null) {
            if (this.entryName == null) {
                this.contentType = "x-java/jar";
            } else {
                try {
                    this.connect();
                    InputStream inputStream = this.getJarFileInternal().getInputStream(this.jarEntry);
                    this.contentType = CachedJarURLConnection.guessContentTypeFromStream(new BufferedInputStream(inputStream));
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.contentType == null) {
                this.contentType = CachedJarURLConnection.guessContentTypeFromName(this.entryName);
            }
            if (this.contentType == null) {
                this.contentType = "content/unknown";
            }
        }
        return this.contentType;
    }

    public int getContentLength() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!this.useJarCache) {
            return super.getContentLength();
        }
        if (this.jarEntry != null) {
            return (int)this.jarEntry.getSize();
        }
        return -1;
    }

    public URL getURL() {
        URL uRL;
        if (this.jarFile instanceof ResourceObject && (uRL = ((ResourceObject)this.jarFile).getResourceURL()) != null) {
            try {
                return URLUtil.getJarEntryURL((URL)uRL, (String)this.entryName);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return super.getURL();
    }
}

