/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.DataType;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import oracle.jrockit.jfr.JFRImpl;
import oracle.jrockit.jfr.ProducerDescriptor;
import oracle.jrockit.jfr.Recording;
import oracle.jrockit.jfr.events.Bits;
import oracle.jrockit.jfr.events.EventControl;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.settings.EventSetting;

@Deprecated
final class MetaProducer
implements ProducerDescriptor {
    private static final int EVENTSETTING_SIZE = DataType.INTEGER.getSize() + 2 * DataType.LONG.getSize() + 2 * DataType.BOOLEAN.getSize();
    private static final int OVERHEAD_SIZE = 16;
    private final URI uri;
    private final int id;
    private final ArrayList<Control> controls = new ArrayList();
    private final Control recordingsEvent;
    private final Control settingsEvent;
    private final ByteBuffer descriptor;
    private final JFRImpl jfr;
    private boolean hasChunk;

    public MetaProducer(JFRImpl jFRImpl) {
        this.jfr = jFRImpl;
        this.id = jFRImpl.nextID();
        try {
            this.uri = new URI("http://www.oracle.com/hotspot/jfr-info/");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InternalError();
        }
        this.recordingsEvent = new Control(jFRImpl.nextID(), "recordings/active", "List of Active Recordings", "");
        this.settingsEvent = new Control(jFRImpl.nextID(), "recordings/settingsChanged", "Event Settings Changed", "");
        this.controls.add(this.recordingsEvent);
        this.controls.add(this.settingsEvent);
        this.descriptor = this.createBinaryDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewChunk() {
        this.hasChunk = true;
        if (this.recordingsEvent.isEnabled()) {
            int n = 0;
            int n2 = 24;
            Collection<Recording> collection = this.jfr.getRecordings();
            Collection<EventSetting> collection2 = this.jfr.getEventSettings().getSettings();
            Iterator<Object> iterator = collection.iterator();
            while (iterator.hasNext()) {
                Recording object2 = iterator.next();
                if (!object2.isStarted() || object2.isStoppingDone()) {
                    iterator.remove();
                    continue;
                }
                n2 += DataType.LONG.getSize() + DataType.INTEGER.getSize() + Bits.length(object2.getName());
            }
            for (EventSetting eventSetting : collection2) {
                if (!eventSetting.isEnabled()) continue;
                n2 += EVENTSETTING_SIZE;
                ++n;
            }
            boolean bl = false;
            ByteBuffer byteBuffer = this.jfr.getThreadBuffer(n2);
            try {
                byteBuffer.putInt(n2);
                byteBuffer.putInt(this.recordingsEvent.getId());
                byteBuffer.putLong(this.jfr.counterTime());
                byteBuffer.putInt(collection.size());
                for (Recording recording : collection) {
                    byteBuffer.putLong(recording.getId());
                    Bits.write(byteBuffer, recording.getName());
                }
                byteBuffer.putInt(n);
                for (EventSetting eventSetting : collection2) {
                    if (!eventSetting.isEnabled()) continue;
                    byteBuffer.putInt(eventSetting.getId());
                    byteBuffer.put(eventSetting.isEnabled() ? (byte)1 : 0);
                    byteBuffer.put(eventSetting.isStacktraceEnabled() ? (byte)1 : 0);
                    byteBuffer.putLong(eventSetting.getThreshold());
                    byteBuffer.putLong(eventSetting.getPeriod());
                }
                bl = true;
            }
            finally {
                this.jfr.releaseThreadBuffer(byteBuffer, bl);
            }
        }
    }

    public void chunkDone() {
        this.hasChunk = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void settingsChanged(Collection<EventSetting> collection, Map<Integer, EventSetting> map) {
        Object object;
        if (!this.settingsEvent.isEnabled() || !this.hasChunk) {
            return;
        }
        ArrayList<EventSetting> arrayList = new ArrayList<EventSetting>(collection.size());
        for (EventSetting eventSetting : collection) {
            object = map.get(eventSetting.getId());
            if (object != null && ((EventSetting)object).equals(eventSetting)) continue;
            arrayList.add(eventSetting);
        }
        if (!arrayList.isEmpty()) {
            int n = 20;
            boolean bl = false;
            object = this.jfr.getThreadBuffer(n += arrayList.size() * EVENTSETTING_SIZE);
            try {
                ((ByteBuffer)object).putInt(n);
                ((ByteBuffer)object).putInt(this.settingsEvent.getId());
                ((ByteBuffer)object).putLong(this.jfr.counterTime());
                ((ByteBuffer)object).putInt(arrayList.size());
                for (EventSetting eventSetting : arrayList) {
                    ((ByteBuffer)object).putInt(eventSetting.getId());
                    ((ByteBuffer)object).put(eventSetting.isEnabled() ? (byte)1 : 0);
                    ((ByteBuffer)object).put(eventSetting.isStacktraceEnabled() ? (byte)1 : 0);
                    ((ByteBuffer)object).putLong(eventSetting.getThreshold());
                    ((ByteBuffer)object).putLong(eventSetting.getPeriod());
                }
                bl = true;
            }
            finally {
                this.jfr.releaseThreadBuffer((ByteBuffer)object, bl);
            }
        }
    }

    private void writeField(DataOutputStream dataOutputStream, String string, String string2, DataType dataType, int n) throws IOException {
        dataOutputStream.writeUTF(string);
        dataOutputStream.writeUTF(string2);
        dataOutputStream.writeUTF("");
        dataOutputStream.write(0);
        dataOutputStream.write(dataType.ordinal());
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(0);
    }

    private void writeField(DataOutputStream dataOutputStream, String string, String string2, DataType dataType) throws IOException {
        this.writeField(dataOutputStream, string, string2, dataType, 0);
    }

    private void writeEvent(DataOutputStream dataOutputStream, Control control, int n) throws IOException {
        dataOutputStream.writeInt(control.getId());
        dataOutputStream.writeUTF(control.getName());
        dataOutputStream.writeUTF(control.getDescription());
        dataOutputStream.writeUTF(control.getPath());
        dataOutputStream.writeBoolean(control.hasStartTime());
        dataOutputStream.writeBoolean(control.hasThread());
        dataOutputStream.writeBoolean(control.hasStackTrace());
        dataOutputStream.writeBoolean(control.isRequestable());
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(0);
    }

    private ByteBuffer createBinaryDescriptor() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.getId());
            dataOutputStream.writeUTF(this.getName());
            dataOutputStream.writeUTF(this.getDescription());
            dataOutputStream.writeUTF(this.getURI().toString());
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(4);
            dataOutputStream.writeInt(2);
            this.writeField(dataOutputStream, "id", "Id", DataType.LONG);
            this.writeField(dataOutputStream, "name", "Name", DataType.STRING);
            dataOutputStream.writeInt(5);
            this.writeField(dataOutputStream, "id", "Id", DataType.INTEGER);
            this.writeField(dataOutputStream, "enabled", "Enabled", DataType.BOOLEAN);
            this.writeField(dataOutputStream, "stacktrace", "Stacktrace", DataType.BOOLEAN);
            this.writeField(dataOutputStream, "threshold", "Threshold", DataType.LONG);
            this.writeField(dataOutputStream, "period", "Period", DataType.LONG);
            dataOutputStream.writeInt(2);
            this.writeField(dataOutputStream, "recordings", "Recordings", DataType.STRUCTARRAY, 0);
            this.writeField(dataOutputStream, "settings", "Active Settings", DataType.STRUCTARRAY, 1);
            dataOutputStream.writeInt(1);
            this.writeField(dataOutputStream, "settings", "Changed Settings", DataType.STRUCTARRAY, 1);
            dataOutputStream.writeInt(2);
            this.writeEvent(dataOutputStream, this.recordingsEvent, 2);
            this.writeEvent(dataOutputStream, this.settingsEvent, 3);
            dataOutputStream.writeInt(0);
            dataOutputStream.flush();
            dataOutputStream.close();
            return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw (InternalError)new InternalError("Could not create descriptors").initCause(iOException);
        }
    }

    @Override
    public ByteBuffer getBinaryDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getDescription() {
        return "Information about Recordings and Settings";
    }

    public Collection<? extends EventControl> getControls() {
        return this.controls;
    }

    @Override
    public Collection<? extends EventDescriptor> getEvents() {
        return this.controls;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return "JFR Metadata";
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public long writeCheckPoint(FileChannel fileChannel, long l) throws IOException {
        return l;
    }

    class Control
    implements EventControl,
    EventDescriptor {
        private boolean enabled;
        private final int id;
        private final String path;
        private final String name;
        private final String description;
        private final URI uri;

        public Control(int n, String string, String string2, String string3) {
            this.id = n;
            this.path = string;
            this.name = string2;
            this.description = string3;
            this.uri = MetaProducer.this.uri.resolve(string);
        }

        @Override
        public void apply(EventSetting eventSetting) {
            this.setEnabled(eventSetting.isEnabled());
        }

        @Override
        public EventDescriptor getDescriptor() {
            return this;
        }

        @Override
        public long getPeriod() {
            return 0L;
        }

        @Override
        public long getThresholdTicks() {
            return 0L;
        }

        @Override
        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        @Override
        public void setPeriod(long l) {
        }

        @Override
        public void setStackTraceEnabled(boolean bl) {
        }

        @Override
        public void setThreshold(long l) {
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public long getThreshold() {
            return 0L;
        }

        @Override
        public URI getURI() {
            return this.uri;
        }

        @Override
        public boolean hasStackTrace() {
            return false;
        }

        @Override
        public boolean hasStartTime() {
            return false;
        }

        @Override
        public boolean hasThread() {
            return false;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public boolean isRequestable() {
            return false;
        }

        @Override
        public boolean isStackTraceEnabled() {
            return false;
        }

        @Override
        public boolean isTimed() {
            return false;
        }
    }
}

