/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.parser;

import com.oracle.jrockit.jfr.DataType;
import com.oracle.jrockit.jfr.InvalidEventDefinitionException;
import com.oracle.jrockit.jfr.InvalidValueException;
import com.oracle.jrockit.jfr.Transition;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import oracle.jrockit.jfr.events.ContentTypeImpl;
import oracle.jrockit.jfr.parser.BufferLostEvent;
import oracle.jrockit.jfr.parser.ContentTypeDescriptor;
import oracle.jrockit.jfr.parser.ContentTypeResolver;
import oracle.jrockit.jfr.parser.EventData;
import oracle.jrockit.jfr.parser.EventProxy;
import oracle.jrockit.jfr.parser.FLREvent;
import oracle.jrockit.jfr.parser.FLRInput;
import oracle.jrockit.jfr.parser.FLRProducer;
import oracle.jrockit.jfr.parser.ParseException;
import oracle.jrockit.jfr.parser.ProducerData;
import oracle.jrockit.jfr.parser.ValueData;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@Deprecated
public final class ChunkParser
implements Iterable<FLREvent> {
    public static final String EVENT_THREAD_ID = "_thread";
    public static final String START_TIME_ID = "_start";
    public static final String STACKTRACE_ID = "_stacktrace";
    private final FLRInput input;
    private final long chunkStart;
    private final long chunkEnd;
    private long start;
    private long end;
    private long startTicks;
    private long ticksPerSecond;
    private TimeZone timezone;
    private Locale locale;
    private byte[] buffer;
    private char[] cbuffer;
    private int major;
    private int minor;
    private int version;
    final HashMap<Integer, ValueData[]> structs = new HashMap();
    final HashMap<Integer, EventData> eventTypes = new HashMap();
    final HashMap<Integer, ContentTypeResolver> resolvers = new HashMap();
    final HashMap<Integer, ContentTypeDescriptor> contentDescs = new HashMap();
    final HashMap<Integer, ProducerData> producers = new HashMap();
    static Attributes empty = new AttributesImpl();

    ChunkParser(FLRInput fLRInput) throws IOException, ParseException {
        this.input = fLRInput;
        this.chunkStart = fLRInput.position();
        this.chunkEnd = this.begin();
    }

    long getChunkStart() {
        return this.chunkStart;
    }

    long getChunkEnd() {
        return this.chunkEnd;
    }

    public List<? extends FLRProducer> getProducers() {
        ArrayList<ProducerData> arrayList = new ArrayList<ProducerData>();
        arrayList.addAll(this.producers.values());
        return arrayList;
    }

    public long getStartTimestampMillis() {
        return this.start;
    }

    public long getEndTimestampMillis() {
        return this.end;
    }

    public long getStartTimeStampTicks() {
        return this.startTicks;
    }

    public long ticksToNanos(long l) {
        return (long)((double)l / ((double)this.ticksPerSecond / 1.0E9));
    }

    public long ticksToMicros(long l) {
        return (long)((double)l / ((double)this.ticksPerSecond / 1000000.0));
    }

    public long ticksToMillis(long l) {
        return (long)((double)l / ((double)this.ticksPerSecond / 1000.0));
    }

    public long ticksToSeconds(long l) {
        return (long)((double)l / (double)this.ticksPerSecond);
    }

    public long getTickFrequency() {
        return this.ticksPerSecond;
    }

    private void move(long l) throws IOException {
        this.input.position(l + this.chunkStart);
    }

    private long absolute(long l) {
        return l + this.chunkStart;
    }

    private long begin() throws IOException, ParseException {
        this.move(0L);
        byte[] byArray = new byte[4];
        this.input.get(byArray);
        if (byArray[0] != 70 || byArray[1] != 76 || byArray[2] != 82 || byArray[3] != 0) {
            throw new ParseException("Bad file header : " + Arrays.toString(byArray));
        }
        this.major = this.input.getShort();
        this.minor = this.input.getShort();
        this.version = this.major << 16 | this.minor;
        long l = this.input.getLong();
        this.move(l);
        long l2 = this.readDescriptors();
        this.start = this.input.getLong();
        this.end = this.input.getLong();
        this.startTicks = this.input.getLong();
        this.ticksPerSecond = this.input.getLong();
        long l3 = this.input.getLong();
        String string = this.readUTF();
        String[] stringArray = string.split("_");
        switch (stringArray.length) {
            case 1: {
                this.locale = new Locale(string);
                break;
            }
            case 2: {
                this.locale = new Locale(stringArray[0], stringArray[1]);
                break;
            }
            case 3: {
                this.locale = new Locale(stringArray[0], stringArray[1], stringArray[2]);
                break;
            }
            default: {
                throw new ParseException("Bad locale " + string);
            }
        }
        int n = this.input.getInt();
        try {
            this.timezone = TimeZone.getTimeZone(TimeZone.getAvailableIDs(n)[0]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ParseException("Bad TimeZone " + n);
        }
        while (l3 != 0L) {
            l3 = this.parseCP(l3);
        }
        this.move(16L);
        return l2;
    }

    EventProxy nextEvent() throws ParseException, IOException {
        int n = this.input.getInt();
        int n2 = this.input.getInt();
        long l = this.input.getLong();
        while (n2 == 1) {
            long l2 = this.input.position();
            this.input.position(l2 + (long)n - 4L - 4L - 8L);
            n = this.input.getInt();
            n2 = this.input.getInt();
            l = this.input.getLong();
        }
        if (n2 == 2) {
            Object[] objectArray = this.readStruct(BufferLostEvent.struct);
            return new BufferLostEvent(this, l, objectArray);
        }
        if (n2 == 0) {
            return null;
        }
        EventData eventData = this.eventTypes.get(n2);
        if (eventData == null) {
            throw new ParseException("Bad event id " + n2);
        }
        Object[] objectArray = this.readStruct((ValueData[])eventData.getValues());
        return new EventProxy(this, n2, l, objectArray);
    }

    public FLREvent next() throws ParseException, IOException {
        return this.nextEvent();
    }

    final Object[] resolve(int n, Number number, long l) {
        ContentTypeResolver contentTypeResolver = this.resolvers.get(n);
        if (contentTypeResolver == null) {
            if (this.contentDescs.get(n) == null) {
                throw new IllegalArgumentException("bad content type: contentTypeID=" + n + " value=" + number + " timestamp=" + l);
            }
            return null;
        }
        while (contentTypeResolver != null && contentTypeResolver.timestamp < l) {
            contentTypeResolver = contentTypeResolver.next;
        }
        while (contentTypeResolver != null) {
            Object[] objectArray = contentTypeResolver.map.get(number);
            if (objectArray != null) {
                return objectArray;
            }
            contentTypeResolver = contentTypeResolver.next;
        }
        return null;
    }

    @Override
    public Iterator<FLREvent> iterator() {
        return new Iterator<FLREvent>(){
            private FLREvent e;

            @Override
            public boolean hasNext() {
                try {
                    this.e = ChunkParser.this.next();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                return this.e != null;
            }

            @Override
            public FLREvent next() {
                return this.e;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    void writeXML(ContentHandler contentHandler) throws SAXException, IOException, ParseException {
        AttributesImpl attributesImpl = new AttributesImpl();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd-HHmmssSS");
        attributesImpl.addAttribute("http://www.oracle.com/hotspot/jvm/", "startTime", "jfr:startTime", "", simpleDateFormat.format(new Date(this.start)));
        attributesImpl.addAttribute("http://www.oracle.com/hotspot/jvm/", "endTime", "jfr:endTime", "", simpleDateFormat.format(new Date(this.end)));
        attributesImpl.addAttribute("http://www.oracle.com/hotspot/jvm/", "startTicks", "jfr:startTicks", "", String.valueOf(this.startTicks));
        attributesImpl.addAttribute("http://www.oracle.com/hotspot/jvm/", "ticksPerMillis", "jfr:ticksPerMillis", "", String.valueOf(this.ticksPerSecond));
        attributesImpl.addAttribute("http://www.oracle.com/hotspot/jvm/", "timezone", "jfr:timezone", "", this.timezone.getID());
        attributesImpl.addAttribute("http://www.oracle.com/hotspot/jvm/", "locale", "jfr:locale", "", this.locale.toString());
        for (ProducerData object2 : this.producers.values()) {
            contentHandler.startPrefixMapping(object2.namespace, object2.uri.toString());
        }
        contentHandler.startElement("http://www.oracle.com/hotspot/jvm/", "chunk", "jfr:chunk", attributesImpl);
        Object object = this.producers.values().iterator();
        while (object.hasNext()) {
            ProducerData producerData = object.next();
            AttributesImpl attributesImpl2 = new AttributesImpl();
            attributesImpl2.addAttribute("http://www.oracle.com/hotspot/jvm/", "id", "jfr:id", "", String.valueOf(producerData.id));
            attributesImpl2.addAttribute("http://www.oracle.com/hotspot/jvm/", "name", "jfr:name", "", producerData.name);
            attributesImpl2.addAttribute("http://www.oracle.com/hotspot/jvm/", "description", "jfr:description", "", producerData.desc);
            attributesImpl2.addAttribute("http://www.oracle.com/hotspot/jvm/", "uri", "jfr:uri", "", producerData.uri.toString());
            attributesImpl2.addAttribute("http://www.oracle.com/hotspot/jvm/", "namespace", "jfr:namespace", "", producerData.namespace);
            contentHandler.startElement("http://www.oracle.com/hotspot/jvm/", "producer", "jfr:producer", attributesImpl2);
            for (EventData eventData : producerData.events) {
                attributesImpl2.clear();
                attributesImpl2.addAttribute("http://www.oracle.com/hotspot/jvm/", "id", "jfr:id", "", String.valueOf(eventData.getId()));
                attributesImpl2.addAttribute("http://www.oracle.com/hotspot/jvm/", "name", "jfr:name", "", eventData.getName());
                attributesImpl2.addAttribute("http://www.oracle.com/hotspot/jvm/", "description", "jfr:description", "", eventData.getDescription());
                attributesImpl2.addAttribute("http://www.oracle.com/hotspot/jvm/", "path", "jfr:path", "", eventData.getPath());
                contentHandler.startElement("http://www.oracle.com/hotspot/jvm/", "event", "jfr:event", attributesImpl2);
                contentHandler.endElement("http://www.oracle.com/hotspot/jvm/", "event", "jfr:event");
            }
            contentHandler.endElement("http://www.oracle.com/hotspot/jvm/", "producer", "jfr:producer");
        }
        while ((object = this.nextEvent()) != null) {
            ((EventProxy)object).xmlSnippet(contentHandler);
        }
        contentHandler.endElement("http://www.oracle.com/hotspot/jvm/", "chunk", "jfr:chunk");
        for (ProducerData producerData : this.producers.values()) {
            contentHandler.endPrefixMapping(producerData.namespace);
        }
    }

    private long parseCP(long l) throws IOException, ParseException {
        int n;
        ProducerData producerData;
        this.move(l);
        int n2 = this.input.getInt();
        long l2 = this.absolute(l + (long)n2);
        int n3 = this.input.getInt();
        long l3 = this.input.getLong();
        if (n3 != 1) {
            throw new ParseException("Illegal checkpoint event id " + n3);
        }
        if (this.minor < 7 && this.major == 0 && (producerData = this.producers.get(n = this.input.getInt())) == null) {
            throw new ParseException("Bad producer id " + n);
        }
        long l4 = this.input.getLong();
        while (this.input.position() < l2) {
            Object object;
            int n4;
            int n5 = this.input.getInt();
            ContentTypeDescriptor contentTypeDescriptor = this.contentDescs.get(n5);
            if (contentTypeDescriptor == null) {
                throw new ParseException("Bad content type in constant pool : " + n5);
            }
            int n6 = this.input.getInt();
            if (n6 == 0) continue;
            HashMap<Number, Object[]> hashMap = new HashMap<Number, Object[]>();
            ValueData[] valueDataArray = (ValueData[])contentTypeDescriptor.getValues();
            for (n4 = 0; n4 < n6; ++n4) {
                object = (Number)this.readPrimitive(contentTypeDescriptor.contentType.getType());
                Object[] objectArray = this.readStruct(valueDataArray);
                hashMap.put((Number)object, objectArray);
            }
            n4 = contentTypeDescriptor.contentType.getOrdinal();
            object = new ContentTypeResolver(contentTypeDescriptor, hashMap, l3, this.resolvers.get(n4));
            this.resolvers.put(n4, (ContentTypeResolver)object);
        }
        return l4;
    }

    private Object[] readStruct(ValueData[] valueDataArray) throws IOException, ParseException {
        int n = valueDataArray.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.readValue(valueDataArray[i]);
        }
        return objectArray;
    }

    private Object readValue(ValueData valueData) throws IOException, ParseException {
        DataType dataType = valueData.getDataType();
        switch (dataType) {
            case ARRAY: {
                int n = this.input.getInt();
                Object[] objectArray = new Object[n];
                DataType dataType2 = DataType.values()[valueData.getInnerType()];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = this.readPrimitive(dataType2);
                }
                return objectArray;
            }
            case STRUCT: {
                ProducerData producerData = this.producers.get(valueData.producer);
                ValueData[] valueDataArray = producerData.structs.get(valueData.getInnerType());
                return this.readStruct(valueDataArray);
            }
            case STRUCTARRAY: {
                int n = this.input.getInt();
                Object[] objectArray = new Object[n];
                ProducerData producerData = this.producers.get(valueData.producer);
                ValueData[] valueDataArray = producerData.structs.get(valueData.getInnerType());
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = this.readStruct(valueDataArray);
                }
                return objectArray;
            }
        }
        return this.readPrimitive(dataType);
    }

    private Object readPrimitive(DataType dataType) throws IOException, ParseException {
        switch (dataType) {
            case BOOLEAN: {
                return this.input.get() != 0;
            }
            case BYTE: 
            case U1: {
                return this.input.get();
            }
            case SHORT: 
            case U2: {
                return this.input.getShort();
            }
            case INTEGER: 
            case U4: {
                return this.input.getInt();
            }
            case LONG: 
            case U8: {
                return this.input.getLong();
            }
            case FLOAT: {
                return Float.valueOf(this.input.getFloat());
            }
            case DOUBLE: {
                return this.input.getDouble();
            }
            case UTF8: {
                return this.readUTF();
            }
            case STRING: {
                return this.readString();
            }
        }
        throw new ParseException("not implemented : " + (Object)((Object)dataType));
    }

    private long readDescriptors() throws IOException, ParseException {
        long l = this.input.position();
        int n = this.input.getInt();
        int n2 = this.input.getInt();
        if (n2 != 0) {
            throw new ParseException("Bad descriptor section, id=" + n2);
        }
        int n3 = this.input.getInt();
        while (n3-- > 0) {
            this.readProducer();
        }
        return l + (long)n;
    }

    private byte[] buffer(int n) {
        if (this.buffer == null || this.buffer.length < n) {
            this.buffer = new byte[n];
        }
        return this.buffer;
    }

    private char[] cbuffer(int n) {
        if (this.cbuffer == null || this.cbuffer.length < n) {
            this.cbuffer = new char[n];
        }
        return this.cbuffer;
    }

    private String readUTF() throws IOException {
        int n = 0xFFFF & this.input.getShort();
        byte[] byArray = this.buffer(n);
        this.input.get(byArray, 0, n);
        return new String(byArray, 0, n, "UTF-8");
    }

    private String readString() throws IOException {
        int n = this.input.getInt();
        char[] cArray = this.cbuffer(n);
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)this.input.getShort();
        }
        return new String(cArray, 0, n);
    }

    private DataType getDataType(int n) throws ParseException {
        try {
            return DataType.values()[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ParseException("Illegal data type : " + n);
        }
    }

    private void readProducer() throws IOException, ParseException {
        Object object;
        Object object2;
        int n;
        String string;
        String string2;
        Object object3;
        boolean bl4 = this.major < 1 && this.minor < 8;
        int n2 = this.input.getInt();
        if (!bl4 && n2 == 0) {
            throw new ParseException("Reserved producer id");
        }
        String string3 = this.readUTF();
        String string4 = this.readUTF();
        String string5 = this.readUTF();
        URI uRI = null;
        try {
            uRI = new URI(string5);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException(uRISyntaxException);
        }
        int n3 = bl4 ? 0 : 1;
        String string6 = n2 == n3 ? "jvm" : "p" + n2;
        int n4 = this.input.getInt();
        ArrayList<String> arrayList = null;
        if (this.minor > 5 || this.major > 0) {
            arrayList = new ArrayList<String>(n4);
            while (n4-- > 0) {
                arrayList.add(this.readUTF());
            }
            n4 = this.input.getInt();
        }
        ArrayList<ValueData[]> arrayList2 = new ArrayList<ValueData[]>(n4);
        while (n4-- > 0) {
            int n5 = this.input.getInt();
            object3 = new ValueData[n5];
            for (int i = 0; i < n5; ++i) {
                ContentTypeImpl contentTypeImpl;
                string2 = this.readUTF();
                string = this.readUTF();
                String string7 = this.readUTF();
                byte bl3 = this.input.get();
                byte by = this.input.get();
                int n6 = this.input.getInt();
                n = this.input.getInt();
                this.input.getInt();
                object2 = Transition.values()[bl3];
                object = this.getDataType(by);
                DataType dataType = object;
                if (object == DataType.ARRAY) {
                    try {
                        dataType = DataType.values()[n];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new ParseException("Invalid inner type " + n);
                    }
                }
                if ((contentTypeImpl = ContentTypeImpl.getBuiltIn(n6)) != null && !contentTypeImpl.isCompatible(dataType)) {
                    throw new ParseException("Incompatible types found: " + (Object)((Object)dataType) + " != " + contentTypeImpl);
                }
                if (contentTypeImpl == null) {
                    contentTypeImpl = new ContentTypeImpl(n6, null, null){
                        private ContentTypeImpl ct;

                        private ContentTypeImpl get() {
                            if (this.ct == null) {
                                this.ct = ChunkParser.this.contentDescs.get((Object)Integer.valueOf((int)this.getOrdinal())).contentType;
                            }
                            return this.ct;
                        }

                        @Override
                        public String getName() {
                            return this.get().getName();
                        }

                        @Override
                        public DataType getType() {
                            return this.get().getType();
                        }

                        @Override
                        public String toString() {
                            return this.get().toString();
                        }
                    };
                }
                String string8 = null;
                if (((DataType)((Object)object)).isPrimitive() && n > 0) {
                    string8 = (String)arrayList.get(n - 1);
                }
                try {
                    object3[i] = new ValueData(n2, string6, string2, string, string7, string8, (Transition)((Object)object2), (DataType)((Object)object), contentTypeImpl, n);
                    continue;
                }
                catch (InvalidValueException invalidValueException) {
                    throw new ParseException("Could not read value", invalidValueException);
                }
            }
            arrayList2.add((ValueData[])object3);
            this.structs.put(this.structs.size() + 1, (ValueData[])object3);
        }
        n4 = this.input.getInt();
        ArrayList<EventData> arrayList3 = new ArrayList<EventData>(n4);
        while (n4-- > 0) {
            int n6 = this.input.getInt();
            String string9 = this.readUTF();
            string2 = this.readUTF();
            string = this.readUTF();
            boolean bl5 = this.input.get() != 0;
            boolean string11 = this.input.get() != 0;
            boolean bl = this.input.get() != 0;
            boolean bl2 = this.input.get() != 0;
            n = this.input.getInt();
            this.input.getInt();
            object2 = arrayList2.get(n);
            if (bl5 || string11 || bl) {
                object = new ArrayList(((ValueData[])object2).length + 3);
                try {
                    if (bl5) {
                        ((ArrayList)object).add(new ValueData(n2, string6, START_TIME_ID, "Start time", "", null, Transition.None, ContentTypeImpl.MILLIS.getType(), ContentTypeImpl.MILLIS, 0));
                    }
                    if (string11) {
                        ((ArrayList)object).add(new ValueData(n2, string6, EVENT_THREAD_ID, "Event thread", null, "", Transition.None, ContentTypeImpl.OSTHREAD.getType(), ContentTypeImpl.OSTHREAD, 0));
                    }
                    if (bl) {
                        ((ArrayList)object).add(new ValueData(n2, string6, STACKTRACE_ID, "Stacktrace", "", null, Transition.None, ContentTypeImpl.STACKTRACE.getType(), ContentTypeImpl.STACKTRACE, 0));
                    }
                }
                catch (InvalidValueException invalidValueException) {
                    throw new ParseException("Could not read event " + string9, invalidValueException);
                }
                ((ArrayList)object).addAll(Arrays.asList(object2));
                object2 = ((ArrayList)object).toArray(new ValueData[((ArrayList)object).size()]);
            }
            try {
                object = new EventData(n2, uRI, string6, string9, string2, string, bl5, string11, bl, bl5, bl2, n6, (ValueData)object2);
                this.eventTypes.put(n6, (EventData)object);
                arrayList3.add((EventData)object);
            }
            catch (InvalidEventDefinitionException | InvalidValueException exception) {
                throw new ParseException("Could not read event", exception);
            }
        }
        n4 = this.input.getInt();
        object3 = new HashMap();
        ProducerData producerData = new ProducerData(n2, string3, string4, uRI, string6, arrayList3, (HashMap<Integer, ContentTypeDescriptor>)object3, arrayList2);
        int n7 = 0;
        while (n4-- > 0) {
            int n8 = this.input.getInt();
            String string10 = this.readUTF();
            String string9 = this.readUTF();
            byte by = this.input.get();
            int n9 = this.input.getInt();
            DataType dataType = this.getDataType(by);
            object2 = ContentTypeImpl.getBuiltIn(n8);
            if (object2 == null) {
                object2 = new ContentTypeImpl(n8, dataType, string10);
            }
            object = new ContentTypeDescriptor((ContentTypeImpl)object2, string9, n7++, producerData, n9);
            this.contentDescs.put(n8, (ContentTypeDescriptor)object);
            ((HashMap)object3).put(n8, object);
        }
        this.producers.put(n2, producerData);
    }

    static String xmlName(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string.length() > 0) {
            stringBuilder.append(string);
        } else {
            stringBuilder.append(string2);
        }
        int n = stringBuilder.length();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = c = stringBuilder.charAt(i);
            if (i == 0 && !Character.isUnicodeIdentifierStart(c)) {
                c2 = '_';
            }
            if (i != 0 && !Character.isUnicodeIdentifierPart(c)) {
                c2 = '_';
            }
            if (c == c2) continue;
            stringBuilder.setCharAt(i, c2);
        }
        return stringBuilder.toString();
    }
}

