/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import demo.DemoUtil;
import iaik.asn1.ASN1Object;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs7.EncryptedContentInfo;
import iaik.pkcs.pkcs7.EncryptedContentInfoStream;
import iaik.pkcs.pkcs7.EncryptedData;
import iaik.pkcs.pkcs7.EncryptedDataStream;
import iaik.security.random.SecRandom;
import iaik.utils.StreamCopier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidParameterSpecException;

public class PKCS7CMSEncryptedData {
    SecureRandom random;

    public void start() {
        String string = "This is the test message.";
        System.out.println("Test message: \"" + string + "\"");
        System.out.println();
        byte[] byArray = string.getBytes();
        try {
            byte[] byArray2 = null;
            System.out.println("Stream implementation demos");
            System.out.println("===========================");
            System.out.println("\nEncryptedDataStream demo [create]:\n");
            byte[] byArray3 = this.createEncryptedDataStream(byArray, (AlgorithmID)AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC.clone(), "password".toCharArray());
            System.out.println("\nEncryptedDataStream demo [parse]:\n");
            byArray2 = this.getEncryptedDataStream(byArray3, "password".toCharArray());
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("Testing compatibility to PKCS#7...");
            System.out.println("\nCMS EncryptedDataStream demo [create]:\n");
            byArray3 = this.createEncryptedDataStream(byArray, (AlgorithmID)AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC.clone(), "password".toCharArray());
            System.out.println("\nPKCS#7 EncryptedDataStream demo [parse]:\n");
            byArray2 = this.getPKCS7EncryptedDataStream(byArray3, "password".toCharArray());
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nPKCS7 EncryptedDataStream demo [create]:\n");
            byArray3 = this.createPKCS7EncryptedDataStream(byArray, (AlgorithmID)AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC.clone(), "password".toCharArray());
            System.out.println("\nCMS EncryptedDataStream demo [parse]:\n");
            byArray2 = this.getEncryptedDataStream(byArray3, "password".toCharArray());
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nNon-stream implementation demos");
            System.out.println("===============================");
            ASN1Object aSN1Object = null;
            System.out.println("\nEncryptedData demo [create]:\n");
            aSN1Object = this.createEncryptedData(byArray, (AlgorithmID)AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC.clone(), "password".toCharArray());
            System.out.println("\nEncryptedData demo [parse]:\n");
            byArray2 = this.getEncryptedData(aSN1Object, "password".toCharArray());
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("Testing compatibility to PKCS#7...");
            System.out.println("\nCMS EncryptedData demo [create]:\n");
            aSN1Object = this.createEncryptedData(byArray, (AlgorithmID)AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC.clone(), "password".toCharArray());
            System.out.println("\nPKCS#7 EncryptedData demo [parse]:\n");
            byArray2 = this.getPKCS7EncryptedData(aSN1Object, "password".toCharArray());
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nPKCS#7 EncryptedData demo [create]:\n");
            aSN1Object = this.createPKCS7EncryptedData(byArray, (AlgorithmID)AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC.clone(), "password".toCharArray());
            System.out.println("\nCMS EncryptedData demo [parse]:\n");
            byArray2 = this.getEncryptedData(aSN1Object, "password".toCharArray());
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DemoUtil.initDemos();
        new PKCS7CMSEncryptedData().start();
        System.in.read();
    }

    public byte[] getPKCS7EncryptedDataStream(byte[] byArray, char[] cArray) throws IOException, PKCSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        EncryptedDataStream encryptedDataStream = new EncryptedDataStream((InputStream)byteArrayInputStream);
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfoStream encryptedContentInfoStream = (EncryptedContentInfoStream)encryptedDataStream.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfoStream.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfoStream.getContentEncryptionAlgorithm().getName());
        try {
            encryptedDataStream.setupCipher(cArray);
            InputStream inputStream = encryptedDataStream.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
            streamCopier.copyStream();
            return byteArrayOutputStream.toByteArray();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PKCSException("Key error: " + invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new PKCSException("Invalid Parameters: " + invalidAlgorithmParameterException.toString());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new PKCSException("Invalid Parameters: " + invalidParameterSpecException.toString());
        }
    }

    public byte[] getPKCS7EncryptedData(ASN1Object aSN1Object, char[] cArray) throws IOException, PKCSException {
        EncryptedData encryptedData = new EncryptedData(aSN1Object);
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfo encryptedContentInfo = (EncryptedContentInfo)encryptedData.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfo.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfo.getContentEncryptionAlgorithm().getName());
        try {
            encryptedData.setupCipher(cArray);
            return encryptedData.getContent();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PKCSException("Key error: " + invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new PKCSException("Invalid Parameters: " + invalidAlgorithmParameterException.toString());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new PKCSException("Invalid Parameters: " + invalidParameterSpecException.toString());
        }
    }

    public byte[] getEncryptedDataStream(byte[] byArray, char[] cArray) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        iaik.cms.EncryptedDataStream encryptedDataStream = new iaik.cms.EncryptedDataStream((InputStream)byteArrayInputStream);
        System.out.println("Information about the encrypted data:");
        iaik.cms.EncryptedContentInfoStream encryptedContentInfoStream = encryptedDataStream.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfoStream.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfoStream.getContentEncryptionAlgorithm().getName());
        try {
            encryptedDataStream.setupCipher(cArray);
            InputStream inputStream = encryptedDataStream.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
            streamCopier.copyStream();
            return byteArrayOutputStream.toByteArray();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("Invalid Parameters: " + invalidAlgorithmParameterException.toString());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new CMSException("Invalid Parameters: " + invalidParameterSpecException.toString());
        }
    }

    public byte[] getEncryptedData(ASN1Object aSN1Object, char[] cArray) throws IOException, CMSException {
        iaik.cms.EncryptedData encryptedData = new iaik.cms.EncryptedData(aSN1Object);
        System.out.println("Information about the encrypted data:");
        iaik.cms.EncryptedContentInfo encryptedContentInfo = (iaik.cms.EncryptedContentInfo)encryptedData.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfo.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfo.getContentEncryptionAlgorithm().getName());
        try {
            encryptedData.setupCipher(cArray);
            return encryptedData.getContent();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("Invalid Parameters: " + invalidAlgorithmParameterException.toString());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new CMSException("Invalid Parameters: " + invalidParameterSpecException.toString());
        }
    }

    public byte[] createPKCS7EncryptedDataStream(byte[] byArray, AlgorithmID algorithmID, char[] cArray) throws IOException, PKCSException {
        EncryptedDataStream encryptedDataStream;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            encryptedDataStream = new EncryptedDataStream((InputStream)byteArrayInputStream, 2048);
            encryptedDataStream.setupCipher(algorithmID, cArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PKCSException("Key error: " + invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        encryptedDataStream.writeTo((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public ASN1Object createPKCS7EncryptedData(byte[] byArray, AlgorithmID algorithmID, char[] cArray) throws IOException, PKCSException {
        EncryptedData encryptedData;
        try {
            encryptedData = new EncryptedData(byArray);
            encryptedData.setupCipher(algorithmID, cArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PKCSException("Key error: " + invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
        return encryptedData.toASN1Object();
    }

    public byte[] createEncryptedDataStream(byte[] byArray, AlgorithmID algorithmID, char[] cArray) throws IOException, CMSException {
        iaik.cms.EncryptedDataStream encryptedDataStream;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            encryptedDataStream = new iaik.cms.EncryptedDataStream((InputStream)byteArrayInputStream, 2048);
            encryptedDataStream.setupCipher(algorithmID, cArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        encryptedDataStream.writeTo((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public ASN1Object createEncryptedData(byte[] byArray, AlgorithmID algorithmID, char[] cArray) throws IOException, CMSException {
        iaik.cms.EncryptedData encryptedData;
        try {
            encryptedData = new iaik.cms.EncryptedData(byArray);
            encryptedData.setupCipher(algorithmID, cArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
        return encryptedData.toASN1Object();
    }

    public PKCS7CMSEncryptedData() {
        System.out.println();
        System.out.println("***********************************************************************************************");
        System.out.println("*                                 PKCS7CMSEncryptedData demo                                  *");
        System.out.println("* (tests the CMS EncryptedData against the IAIK-JCE PKCS#7 EncryptedData type implementation) *");
        System.out.println("***********************************************************************************************");
        System.out.println();
        this.random = SecRandom.getDefault();
    }
}

