/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2008;

import finanze.IDTE.generale2008.BaseTelem;
import finanze.IDTE.generale2008.CF;
import finanze.IDTE.generale2008.ComuniProvincia;
import finanze.IDTE.generale2008.DataSogei;
import finanze.IDTE.generale2008.PIVA;
import finanze.IDTE.resources.RecordParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.CollationKey;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class Util {
    public static int restituisciTipo(int pos, String modello) {
        try {
            BaseTelem.getInstance().riempiControlli(2, modello, "08");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int out = BaseTelem.getInstance().getRecordBcontrolli().getFormatoAt(pos - 1);
        return out;
    }

    public static String accapo(int dove, String riga) {
        String out = "";
        if (dove >= riga.length()) {
            out = riga;
        } else {
            int taglio = riga.lastIndexOf(32, dove);
            int lfPresente = riga.lastIndexOf(10, dove);
            if (taglio == 0 || taglio == -1) {
                taglio = dove;
            }
            if (lfPresente >= 0) {
                taglio = lfPresente;
            }
            out = riga.length() - taglio >= dove ? riga.substring(0, taglio) + "\n" + Util.accapo(dove, riga.substring(taglio, riga.length()).trim()) : riga.substring(0, taglio) + "\n" + riga.substring(taglio, riga.length()).trim();
        }
        return out;
    }

    public static String aggiungiMigliaia(String num) {
        if (Util.numerico(num)) {
            String out = new String();
            int pos = num.indexOf(",");
            int i = pos > 0 ? pos : num.length();
            while (i > 0) {
                if (i - 3 <= 0 || i - 3 == 1 && num.charAt(0) == '-') {
                    return num.substring(0, i) + out + (pos > 0 ? num.substring(pos, num.length()) : "");
                }
                out = "." + num.substring(i - 3, i) + out;
                i -= 3;
            }
        }
        System.out.println("Errore nella conversione delle migliaia del numero:" + num);
        return "0";
    }

    public static int aggRc(int rc, int rc_new) {
        if (rc_new > rc) {
            return rc_new;
        }
        return rc;
    }

    public static double arrotondaDecimali(double valore, int decimali) {
        double fattore = Math.pow(10.0, new Integer(decimali).doubleValue());
        return (double)Math.round(valore * fattore) / fattore;
    }

    public static String arrotondaDecimali(String valore, int decimali) {
        String out = "";
        double dx = Util.valoreDouble(valore);
        double fattore = Math.pow(10.0, new Integer(decimali).doubleValue());
        int ix = new Double(dx = (double)Math.round(dx * fattore) / fattore).intValue();
        out = (double)ix == dx ? "" + ix : ("" + dx).replace('.', ',');
        int i = out.indexOf("E");
        if (i > 0) {
            int f = Integer.parseInt(out.substring(i + 1));
            out = String.valueOf(out.charAt(0)) + out.substring(2, f + 2) + ',' + out.substring(f + 2, i);
        }
        return out;
    }

    public static String cambiaEstensione(String nomeFile, String nuovaEstensione) {
        int p = nomeFile.lastIndexOf(46);
        if (p < 0) {
            return nomeFile + "." + nuovaEstensione;
        }
        return nomeFile.substring(0, p) + "." + nuovaEstensione;
    }

    public static int compare(String s1, String s2) {
        int l2;
        int l1 = s1.length();
        if (l1 != (l2 = s2.length())) {
            return l1 > l2 ? l2 : l1;
        }
        int i = 0;
        while (i < l1) {
            if (s1.charAt(i) != s2.charAt(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int contaCampiPresenti(RecordParser rp, int primo, int ultimo) {
        int conta = 0;
        while (primo <= ultimo) {
            if (!Util.isNonValorizzato(rp.prendiValore(primo))) {
                ++conta;
            }
            ++primo;
        }
        return conta;
    }

    public static int contaCampiPresenti(RecordParser rp, int[] codCampi) {
        int conta = 0;
        int i = 0;
        while (i < codCampi.length) {
            if (!Util.isNonValorizzato(rp.prendiValore(codCampi[i]))) {
                ++conta;
            }
            ++i;
        }
        return conta;
    }

    public static int contaCaratteri(String s, char c, int pos) {
        int contatore = 0;
        int i = pos + 1;
        while (i < s.trim().length()) {
            if (s.charAt(i) == c) {
                ++contatore;
            }
            ++i;
        }
        return contatore;
    }

    public static int[] contaRec(Vector memoRec, int[] ctrRecZ) {
        Iterator iter = memoRec.iterator();
        while (iter.hasNext()) {
            byte[] element = (byte[])iter.next();
            int i = element[0] - 65;
            if (i < 0 || i > 25) continue;
            int n = i;
            ctrRecZ[n] = ctrRecZ[n] + 1;
        }
        return ctrRecZ;
    }

    public static boolean controllaPeriodoImposta(String data1, String data2) {
        int giorno = 0;
        int mese = 0;
        int anno = 0;
        int giornomese = 0;
        giorno = Integer.parseInt(data2.substring(0, 2));
        mese = Integer.parseInt(data2.substring(2, 4));
        anno = Integer.parseInt(data2.substring(4, 6));
        switch (mese) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                giornomese = 31;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                giornomese = 30;
                break;
            }
            case 2: {
                if (anno % 4 == 0 && anno != 1900) {
                    giornomese = 29;
                    break;
                }
                giornomese = 28;
                break;
            }
        }
        if (giorno == giornomese) {
            giorno = 1;
            if (mese == 12) {
                mese = 1;
                ++anno;
            } else {
                ++mese;
            }
        } else {
            ++giorno;
        }
        data2 = String.valueOf(Util.formNum(2, giorno)) + Util.formNum(2, mese) + Util.formNum(2, --anno);
        if ((String.valueOf(data1.substring(0, 2)) + data1.substring(2, 4)).equals("2902")) {
            return data2.equals("2802" + anno) || data2.equals("0103" + anno);
        }
        return data1.equals(data2);
    }

    public static boolean controllaStruttura(String f, String s) {
        if (f.length() != s.length()) {
            return false;
        }
        int i = 0;
        while (i < f.length()) {
            if (f.charAt(i) == 'C' && Character.isDigit(s.charAt(i))) {
                return false;
            }
            if (f.charAt(i) == 'N' && !Character.isDigit(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean controlloCF(String s) {
        PIVA p;
        String cf = s.trim();
        if (cf.length() == 16) {
            CF c;
            char x = cf.charAt(11);
            boolean xFlag = false;
            if (x >= 'A' && x <= 'M' || x == 'Z') {
                xFlag = true;
            }
            if ((c = new CF(cf)).getCfCodiceRitorno() == 0 && Util.controllaStruttura("CCCCCCNN", cf.substring(0, 8)) && xFlag) {
                return true;
            }
        }
        return cf.length() == 11 && (p = new PIVA(cf, 'F')).getPIVACodiceRitorno() == 0;
    }

    public static boolean controlloCN(String s) {
        PIVA p;
        String cf = s.trim();
        return cf.length() == 11 && (p = new PIVA(cf, 'F')).getPIVACodiceRitorno() == 0;
    }

    public static boolean controlloData(String s) {
        DataSogei d = new DataSogei(s);
        return d.getOk();
    }

    public static boolean controlloData(String s, int min, int max) {
        DataSogei d = new DataSogei(s, min, max);
        return d.getOk();
    }

    public static boolean controlloMeseAnno(String data) {
        return Util.controlloMeseAnno(data, 1900, 2100);
    }

    public static boolean controlloMeseAnno(String data, int minAnno, int maxAnno) {
        int anno;
        if ((data = data.trim()).equals("0")) {
            return true;
        }
        if (data.length() != 6) {
            return false;
        }
        int mese = Integer.parseInt(data.substring(0, 2));
        if (mese + (anno = Integer.parseInt(data.substring(2, 6))) == 0) {
            return true;
        }
        return mese > 0 && mese < 13 && anno >= minAnno && anno <= maxAnno;
    }

    public static boolean controlloPI(String s) {
        PIVA p;
        String cf = s.trim();
        return cf.length() == 11 && (p = new PIVA(cf, 'I')).getPIVACodiceRitorno() == 0;
    }

    public static boolean controlloProtocolloTelematico(String protocollo, String progr_dich, String annoDich) {
        boolean protOK = true;
        String data_invio = "";
        String ora_invio = "";
        String min_invio = "";
        String sec_invio = "";
        String num_invio = "";
        boolean protAss = false;
        if (protocollo.trim().length() == 17 && progr_dich.trim().length() == 6 && BaseTelem.currentSystem == 0 && (protocollo.equals("00000000000000000") || progr_dich.equals("000000"))) {
            return false;
        }
        if (protocollo.trim().length() == 17) {
            if (protocollo.equals("00000000000000000")) {
                protAss = true;
            } else {
                data_invio = String.valueOf(protocollo.substring(4, 6)) + protocollo.substring(2, 4) + "20" + protocollo.substring(0, 2);
                ora_invio = protocollo.substring(6, 8);
                min_invio = protocollo.substring(8, 10);
                sec_invio = protocollo.substring(10, 12);
                num_invio = protocollo.substring(12, 17);
                if (!Util.isNumericoAssoluto(data_invio) || data_invio.equals("00000000") || data_invio.equals("0000" + annoDich) || !Util.controlloData(data_invio)) {
                    protOK = false;
                } else if (!Util.isNumericoAssoluto(ora_invio) || Util.valoreDouble(ora_invio) > 47.0) {
                    protOK = false;
                } else if (!Util.isNumericoAssoluto(min_invio) || Util.valoreDouble(min_invio) > 59.0) {
                    protOK = false;
                } else if (!Util.isNumericoAssoluto(sec_invio) || Util.valoreDouble(sec_invio) > 59.0) {
                    protOK = false;
                } else if (!Util.isNumericoAssoluto(num_invio) || Util.valoreDouble(num_invio) == 0.0) {
                    protOK = false;
                }
            }
        } else if (protocollo.trim().length() == 0) {
            protAss = true;
        } else {
            protOK = false;
        }
        if (progr_dich.trim().length() == 6) {
            if (!Util.isNumericoAssoluto(progr_dich) || progr_dich.equals("000000") && !protAss) {
                protOK = false;
            }
        } else if (progr_dich.trim().length() == 0) {
            if (!protAss) {
                protOK = false;
            }
        } else {
            protOK = false;
        }
        return protOK;
    }

    public static String convertiAccentate(String s) {
        s = Util.replaceString(s, "\u00c0", "A'");
        s = Util.replaceString(s, "\u00c8", "E'");
        s = Util.replaceString(s, "\u00cc", "I'");
        s = Util.replaceString(s, "\u00d2", "O'");
        s = Util.replaceString(s, "\u00d9", "U'");
        s = Util.replaceString(s, "\u00c9", "E'");
        return s;
    }

    public static int countDays(String dataI, String dataF) {
        DataSogei dataSogei1 = new DataSogei(dataI);
        DataSogei dataSogei2 = new DataSogei(dataF);
        long giornatePeriodo = dataSogei2.getGiulianoAnno() - dataSogei1.getGiulianoAnno();
        int numGiorni = new Long(giornatePeriodo).intValue();
        return ++numGiorni;
    }

    public static String dateWithoutSlash(String date) {
        int firstSlash = date.indexOf("/");
        int lastSlash = date.lastIndexOf("/");
        String firstToken = date.substring(0, firstSlash);
        String secondToken = date.substring(firstSlash + 1, lastSlash);
        String thirdToken = date.substring(lastSlash + 1);
        return Util.formNum(2, firstToken) + Util.formNum(2, secondToken) + thirdToken;
    }

    public static boolean detectLowValueChars(String s) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) < ' ') {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean esisteAlmenoUnCampo(RecordParser rp, int primo, int ultimo) {
        while (primo <= ultimo) {
            if (!Util.isNonValorizzato(rp.prendiValore(primo))) {
                return true;
            }
            ++primo;
        }
        return false;
    }

    public static boolean esisteAlmenoUnCampo(RecordParser rp, int[] codCampi) {
        int i = 0;
        while (i < codCampi.length) {
            if (!Util.isNonValorizzato(rp.prendiValore(codCampi[i]))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean esisteCodAtt(String codatt) {
        if (BaseTelem.getInstance().getDescCodAtt() == null) {
            try {
                BaseTelem.getInstance().riempiDescCodAtt();
            }
            catch (IOException e) {
                System.out.println("Errore nel caricamento dei Codici Attivit\u00e0");
            }
        }
        return BaseTelem.getInstance().getDescCodAtt(codatt).length() != 0;
    }

    public static boolean esisteCodEnteT3(String cod) {
        boolean trovato = false;
        String[] codiceEnte = new String[]{"0001", "0002", "0006", "0007", "0008", "0009", "0010", "0011", "0012", "0013", "0014", "0015", "0016", "0017", "0018", "0019", "0020", "0021", "00AL", "00AN", "00AP", "00AR", "00BG", "00BI", "00BL", "00BO", "00BS", "00CH", "00CO", "00CS", "00FC", "00FE", "00FR", "00GE", "00IM", "00KR", "00LE", "00LU", "00MC", "00MI", "00MN", "00MO", "00MS", "00NA", "00NU", "00PA", "00PD", "00PE", "00PG", "00PI", "00PO", "00PR", "IALI", "NARI", "00PU", "00PV", "00PZ", "00RA", "00RE", "00RM", "00RN", "00RO", "00SA", "00SR", "00SV", "00TA", "00TE", "00TO", "00TP", "00TV", "00UD", "00VA", "00VE", "00VI", "00VR", "00VV", "A006", "A024", "A034", "A038", "A040", "A087", "A110", "A122", "A145", "A150", "A161", "A162", "A163", "A182", "A191", "A216", "A233", "A251", "A270", "A271", "A281", "A285", "A345", "A360", "A389", "A390", "A392", "A393", "A399", "A433", "A451", "A459", "A463", "A470", "A479", "A519", "A529", "A535", "A539", "A547", "A573", "A578", "A668", "A684", "A703", "A717", "A734", "A743", "A747", "A757", "A794", "A850", "A859", "A893", "A918", "A944", "B011", "B012", "B019", "B034", "B083", "B098", "B100", "B104", "B129", "B138", "B156", "B248", "B249", "B266", "B300", "B354", "B371", "B392", "B394", "B399", "B413", "B502", "B506", "B519", "B539", "B566", "B581", "B584", "B612", "B619", "B640", "B644", "B653", "B669", "B696", "B744", "B781", "B819", "B825", "B832", "B844", "B865", "B885", "B905", "B910", "B914", "B915", "B936", "B938", "B962", "B963", "B967", "B998", "C034", "C044", "C052", "C059", "C076", "C111", "C118", "C128", "C129", "C136", "C195", "C203", "C207", "C219", "C286", "C287", "C312", "C330", "C337", "C349", "C351", "C357", "C388", "C398", "C408", "C426", "C439", "C520", "C524", "C553", "C566", "C573", "C574", "C585", "C588", "C616", "C618", "C619", "C627", "C632", "C650", "C691", "C697", "C703", "C707", "C735", "C750", "C765", "C767", "C773", "C806", "C814", "C852", "C853", "C860", "C883", "C895", "C912", "C925", "C933", "C957", "C980", "C986", "D037", "D057", "D086", "D107", "D117", "D166", "D208", "D223", "D227", "D231", "D245", "D269", "D270", "D305", "D370", "D379", "D390", "D403", "D406", "D434", "D458", "D510", "D542", "D548", "D575", "D583", "D599", "D607", "D612", "D704", "D711", "D761", "D769", "D773", "D815", "D863", "D883", "D918", "D940", "D949", "D969", "D976", "E010", "E026", "E036", "E040", "E041", "E058", "E089", "E094", "E136", "E169", "E193", "E202", "E204", "E216", "E226", "E232", "E253", "E261", "E289", "E320", "E329", "E372", "E388", "E438", "E463", "E466", "E488", "E496", "E506", "E512", "E563", "E632", "E667", "E706", "E730", "E734", "E738", "E772", "E788", "E791", "E801", "E864", "E889", "E897", "E904", "E905", "E912", "E928", "E946", "E951", "E961", "E970", "E975", "F023", "F082", "F086", "F087", "F101", "F119", "F127", "F138", "F152", "F205", "F220", "F229", "F240", "F244", "F250", "F257", "F267", "F284", "F347", "F356", "F400", "F416", "F443", "F463", "F464", "F473", "F481", "F484", "F522", "F551", "F585", "F590", "F604", "F634", "F690", "F704", "F706", "F712", "F716", "F729", "F745", "F764", "F817", "F839", "F844", "F851", "F872", "F887", "F930", "F960", "F966", "F979", "F990", "G039", "G047", "G062", "G074", "G125", "G148", "G170", "G184", "G205", "G224", "G226", "G273", "G318", "G337", "G353", "G354", "G393", "G417", "G433", "G467", "G478", "G482", "G489", "G535", "G536", "G555", "G564", "G590", "G605", "G620", "G645", "G663", "G687", "G698", "G702", "G713", "G749", "G751", "G752", "G779", "G787", "G804", "G812", "G825", "G844", "G859", "G914", "G917", "G921", "G942", "G943", "G947", "G999", "H010", "H026", "H072", "H078", "H118", "H122", "H199", "H210", "H211", "H218", "H223", "H225", "H248", "H268", "H274", "H280", "H294", "H298", "H307", "H355", "H361", "H404", "H426", "H467", "H484", "H501", "H541", "H556", "H579", "H598", "H620", "H630", "H642", "H645", "H699", "H703", "H720", "H730", "H749", "H791", "H823", "H829", "H835", "H883", "H887", "H901", "H945", "H985", "I011", "I053", "I123", "I128", "I133", "I138", "I193", "I221", "I234", "I342", "I373", "I390", "I396", "I425", "I430", "I433", "I444", "I452", "I462", "I483", "I496", "I537", "I549", "I551", "I595", "I608", "I628", "I639", "I641", "I666", "I689", "I690", "I725", "I726", "I802", "I805", "I822", "I829", "I845", "I862", "I873", "I903", "I921", "I930", "I962", "L014", "L049", "L057", "L063", "L074", "L094", "L103", "L109", "L112", "L117", "L120", "L156", "L157", "L182", "L183", "L213", "L219", "L233", "L245", "L297", "L339", "L346", "L356", "L380", "L383", "L400", "L424", "L447", "L472", "L483", "L484", "L494", "L551", "L565", "L677", "L700", "L719", "L723", "L736", "L738", "L741", "L781", "L816", "L820", "L833", "L844", "L869", "L885", "L919", "L949", "L969", "M017", "M044", "M045", "M048", "M082", "M104", "M125", "M187", "M212", "M272", "001C", "002C", "003C"};
        int i = 0;
        while (i < codiceEnte.length) {
            if (cod.equals(codiceEnte[i])) {
                trovato = true;
                break;
            }
            ++i;
        }
        return trovato;
    }

    public static boolean esisteCodUff(String coduff) {
        if (BaseTelem.getInstance().getDescCodUff() == null) {
            try {
                BaseTelem.getInstance().riempiDescCodUff();
            }
            catch (IOException e) {
                System.out.println("Errore nel caricamento dei Codici Ufficio");
            }
        }
        return BaseTelem.getInstance().getDescCodUff(coduff).length() != 0;
    }

    public static boolean esisteCodiceConcessione(String cod) {
        boolean trovato = false;
        String[] codiceConc = new String[]{"001", "003", "005", "007", "008", "010", "012", "014", "016", "017", "019", "020", "021", "022", "024", "025", "027", "028", "030", "032", "033", "034", "035", "037", "039", "041", "043", "045", "047", "048", "050", "051", "052", "053", "054", "056", "057", "059", "061", "062", "063", "064", "066", "067", "068", "070", "071", "073", "074", "075", "077", "078", "079", "080", "082", "083", "085", "087", "089", "091", "092", "093", "094", "095", "096", "097", "099", "100", "102", "103", "104", "105", "106", "108", "109", "110", "112", "113", "114", "115", "117", "119", "121", "122", "124", "125", "132", "133", "134", "135", "136", "137", "138", "139", "291", "292", "293", "294", "295", "296", "297", "298", "299"};
        int i = 0;
        while (i < codiceConc.length) {
            if (cod.equals(codiceConc[i])) {
                trovato = true;
                break;
            }
            ++i;
        }
        return trovato;
    }

    public static boolean esisteCodiceEstero(String cod) {
        boolean trovato = false;
        String[] codice = new String[]{"A001", "B001", "B002", "B003", "C001", "D001", "D002", "D003", "D004", "D005", "D006", "D007", "D008", "D009", "D010", "E001", "F001", "G001", "G002", "G003", "H001", "H002", "H003", "6671", "6672", "6674", "6673", "6675", "6676", "6677", "6678", "0513", "0514", "0515", "0516", "0517", "0512", "0108", "0107", "0109", "6800", "6801", "6802", "6803", "0750", "0751", "6805", "6806", "6807", "6820", "6821", "6822", "6808", "6809", "6810", "6811", "6812", "6804", "6679", "6680", "6681", "6682", "6683", "6684", "6685", "1202", "1201", "1203", "1300", "1301", "1303", "1304", "1305", "1306", "6632", "6633", "6634", "6631", "1113", "1114", "1115", "6686", "6630", "6605", "6660", "6666", "6667", "6668", "6624", "6636", "6638", "6661", "6612", "6687", "6601", "6690", "6688", "6629", "6606", "6689", "6602", "6647", "6691", "0801", "0802", "0803", "6693", "6635", "6692", "6650", "1100", "1105", "1106", "1102", "1101", "1103", "1104", "1107", "1108", "1110", "1109", "1111", "1112", "6620", "6617", "6618", "6619", "0204", "0202", "0212", "0218", "0203", "0201", "0205", "0207", "0219", "0213", "0214", "0215", "0216", "0217", "0318", "0302", "0319", "0304", "0305", "0306", "0303", "0314", "0315", "0316", "0313", "0312", "0317", "0721", "0722", "0723", "0724", "0725", "0727", "0728", "0729", "0730", "0731", "0515", "0516", "0517", "0726", "0732", "0512", "0733", "Z001", "Z002", "Z003"};
        int i = 0;
        while (i < codice.length) {
            if (cod.equals(codice[i])) {
                trovato = true;
                break;
            }
            ++i;
        }
        return trovato;
    }

    public static boolean esisteCodiceOperazioneEstero(String cod) {
        boolean trovato = false;
        String[] codiceOperazione = new String[]{"6671", "6672", "6673", "6674", "6675", "6676", "6677", "6678", "0107", "0108", "0109", "0201", "0202", "0203", "0204", "0205", "0207", "0212", "0213", "0214", "0215", "0216", "0217", "0218", "0219", "0302", "0303", "0304", "0305", "0306", "0312", "0313", "0314", "0315", "0316", "0317", "0318", "0319", "0512", "0513", "0514", "0515", "0516", "0517", "0721", "0722", "0723", "0724", "0725", "0726", "0727", "0728", "0729", "0730", "0731", "0732", "0733", "0750", "0751", "0801", "0802", "0803", "1100", "1101", "1102", "1103", "1104", "1105", "1106", "1107", "1108", "1109", "1110", "1111", "1112", "1113", "1114", "1115", "1201", "1202", "1203", "1300", "1301", "1303", "1304", "1305", "1306", "6601", "6602", "6605", "6606", "6612", "6617", "6618", "6619", "6620", "6624", "6629", "6630", "6631", "6632", "6633", "6634", "6635", "6636", "6638", "6647", "6650", "6660", "6661", "6666", "6667", "6668", "6679", "6680", "6681", "6682", "6683", "6684", "6685", "6686", "6687", "6688", "6689", "6690", "6691", "6692", "6693", "6800", "6801", "6802", "6803", "6804", "6805", "6806", "6807", "6808", "6809", "6810", "6811", "6812", "6820", "6821", "6822", "A001", "B001", "B002", "B003", "C001", "D001", "D002", "D003", "D004", "D005", "D006", "D007", "D008", "D009", "D010", "E001", "F001", "G001", "G002", "G003", "H001", "H002", "H003", "Z001", "Z002", "Z003"};
        int i = 0;
        while (i < codiceOperazione.length) {
            if (cod.equals(codiceOperazione[i])) {
                trovato = true;
                break;
            }
            ++i;
        }
        return trovato;
    }

    public static boolean esisteCodicePaeseEstero(String paese) {
        boolean trovato = false;
        String[] paeseEst = new String[]{"002", "003", "004", "005", "006", "007", "008", "009", "010", "011", "012", "013", "015", "016", "017", "018", "019", "020", "021", "022", "023", "024", "025", "026", "027", "028", "029", "031", "032", "033", "034", "035", "036", "037", "038", "039", "040", "041", "042", "043", "044", "045", "046", "047", "048", "049", "050", "051", "052", "053", "054", "055", "056", "057", "058", "059", "061", "062", "063", "064", "065", "066", "067", "068", "069", "070", "071", "072", "073", "074", "075", "076", "077", "078", "080", "081", "082", "083", "084", "085", "087", "088", "089", "090", "091", "092", "093", "094", "095", "097", "098", "100", "101", "102", "103", "104", "105", "106", "107", "109", "110", "112", "113", "114", "115", "116", "117", "118", "119", "120", "121", "122", "123", "124", "125", "126", "127", "128", "129", "130", "131", "132", "133", "134", "135", "136", "137", "138", "139", "141", "142", "143", "144", "145", "146", "147", "148", "149", "150", "151", "152", "153", "154", "155", "156", "157", "158", "159", "160", "161", "162", "163", "164", "166", "167", "168", "169", "175", "176", "177", "178", "180", "182", "183", "185", "186", "187", "188", "189", "190", "191", "192", "193", "194", "195", "196", "197", "198", "199", "200", "201", "202", "203", "204", "205", "206", "207", "208", "209", "210", "211", "212", "213", "214", "215", "216", "217", "218", "219", "220", "221", "222", "223", "225", "226", "227", "228", "229", "230", "231", "232", "233", "234", "235", "236", "237", "238", "239", "240", "241", "242", "243", "244", "245", "246", "247", "248", "249", "250", "251", "252", "253", "254", "255", "256", "257", "258", "259", "260", "261", "262", "263", "264", "265", "266", "267", "268", "269", "270", "271", "272", "273", "274", "275", "276", "277", "278", "279", "280", "281", "282", "283", "284", "285", "286", "287", "288", "289", "290", "799", "794", "795", "796", "797", "798"};
        int i = 0;
        while (i < paeseEst.length) {
            if (paese.equals(paeseEst[i])) {
                trovato = true;
                break;
            }
            ++i;
        }
        return trovato;
    }

    public static boolean esisteComune(String comune) {
        return ComuniProvincia.esisteComune(comune);
    }

    public static boolean esistenzaTuttiCampi(RecordParser rp, int primo, int ultimo, boolean esistenza) {
        while (primo <= ultimo) {
            if (esistenza && Util.isNonValorizzato(rp.prendiValore(primo))) {
                return false;
            }
            if (!esistenza && !Util.isNonValorizzato(rp.prendiValore(primo))) {
                return false;
            }
            ++primo;
        }
        return true;
    }

    public static boolean esistenzaTuttiCampi(RecordParser rp, int[] codCampi, boolean esistenza) {
        int i = 0;
        while (i < codCampi.length) {
            if (esistenza && Util.isNonValorizzato(rp.prendiValore(codCampi[i]))) {
                return false;
            }
            if (!esistenza && !Util.isNonValorizzato(rp.prendiValore(codCampi[i]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean esisteOldCodAtt(String codatt) {
        boolean trovato = false;
        String[] codiceatt = new String[]{"01111", "01112", "01113", "01114", "01115", "01116", "01121", "01122", "01123", "01124", "01131", "01132", "01133", "01134", "01135", "01210", "01221", "01222", "01230", "01241", "01242", "01251", "01252", "01253", "01254", "01255", "01300", "0141A", "0141B", "01411", "01412", "01420", "01500", "02011", "02012", "02020", "05011", "05012", "05021", "05022", "05030", "10100", "10200", "10300", "11110", "11120", "11130", "11200", "12000", "13100", "13200", "14111", "14112", "14121", "14122", "14130", "14210", "14220", "14301", "14302", "14303", "14400", "14501", "14502", "14503", "15111", "15112", "15121", "15122", "15130", "15201", "15202", "15310", "15320", "15330", "15411", "15412", "15413", "15421", "15422", "15423", "15430", "15511", "15512", "15520", "15611", "15612", "15620", "15710", "15720", "15811", "15812", "15820", "15830", "15840", "15850", "15860", "15870", "15880", "15891", "15892", "15893", "15910", "15920", "15931", "15932", "15940", "15950", "15960", "15970", "15980", "15990", "16000", "17110", "17121", "17122", "17131", "17132", "17140", "17150", "17160", "17170", "17210", "17220", "17230", "17240", "17250", "17300", "17401", "17402", "17510", "17520", "17530", "17541", "17542", "17543", "17544", "17545", "17546", "17600", "17710", "17720", "17730", "17740", "17750", "18100", "18210", "18221", "18222", "18230", "18241", "18242", "18243", "18244", "1830A", "1830B", "19100", "19200", "19301", "19302", "19303", "20100", "20200", "20301", "20302", "20400", "20511", "20512", "20521", "20522", "21110", "21120", "21210", "21220", "21230", "21240", "21250", "22110", "22120", "22130", "22140", "22150", "22210", "22220", "22230", "22240", "22250", "22310", "22320", "22330", "23100", "23201", "23202", "23203", "23204", "23300", "24110", "24120", "24130", "24140", "24150", "24160", "24170", "24200", "24300", "24410", "24420", "24511", "24512", "24520", "24610", "24620", "24630", "24640", "24650", "24661", "24662", "24663", "24664", "24665", "24666", "24700", "25110", "25120", "25130", "25210", "25220", "25230", "25240", "26110", "26120", "26130", "26140", "26151", "26152", "26153", "26210", "26220", "26230", "26240", "26250", "26260", "26300", "26400", "26510", "26520", "26530", "26610", "26620", "26630", "26640", "26650", "26660", "26701", "26702", "26703", "26810", "26820", "27100", "27210", "27221", "27222", "27310", "27320", "27330", "27340", "27350", "27410", "27420", "27430", "27440", "27450", "27510", "27520", "27530", "27540", "28110", "28121", "28122", "28210", "28220", "28300", "28401", "28402", "28403", "28404", "28510", "28520", "28610", "28621", "28622", "28630", "28710", "28720", "28730", "28741", "28742", "28743", "28751", "28752", "28753", "28754", "28755", "28756", "29111", "29112", "29120", "29130", "29141", "29142", "29211", "29212", "29221", "29222", "29231", "29232", "29241", "29242", "29243", "29244", "29311", "29312", "29321", "29322", "29400", "29510", "29520", "29530", "29541", "29542", "29543", "29550", "29561", "29562", "29563", "29564", "29565", "29600", "29710", "29720", "30010", "30020", "31101", "31102", "31201", "31202", "31300", "31400", "31500", "31610", "31621", "31622", "32100", "32201", "32202", "32203", "32300", "33101", "33102", "33103", "33104", "33201", "33202", "33203", "33204", "33205", "33300", "33401", "33402", "33403", "33404", "33405", "33406", "33500", "34100", "34200", "34300", "35111", "35112", "35113", "35114", "35120", "35201", "35202", "35203", "35204", "35300", "35411", "35412", "35421", "35422", "35430", "35501", "35502", "36111", "36112", "36121", "36122", "36130", "36141", "36142", "36150", "36210", "36221", "36222", "36300", "36400", "36501", "36502", "36610", "36620", "36631", "36632", "36633", "36634", "36635", "36636", "37100", "37201", "37202", "40100", "40201", "40202", "40300", "41001", "41002", "45110", "45120", "45210", "45220", "45230", "45240", "45250", "45310", "45320", "45330", "45340", "45410", "45420", "45430", "45440", "45451", "45452", "45500", "50100", "50201", "50202", "50203", "50204", "50205", "50300", "50401", "50402", "50403", "5050A", "5050B", "51110", "51120", "51130", "51140", "51150", "51160", "51170", "51180", "51190", "51211", "51212", "51220", "51231", "51232", "51241", "51242", "51250", "51310", "51321", "51322", "51323", "51331", "51332", "51341", "51342", "51350", "51361", "51362", "51371", "51372", "51381", "51382", "5139A", "5139B", "51391", "51392", "51393", "5141A", "5141B", "51411", "51412", "51413", "5142B", "51421", "51422", "51423", "51424", "51425", "5143A", "5143B", "51431", "51432", "51433", "51434", "51435", "51441", "51442", "51443", "51444", "51445", "51450", "51461", "51462", "51471", "51472", "51473", "51474", "51475", "51476", "51477", "51478", "51479", "51511", "51512", "51513", "51521", "51522", "51523", "51524", "51531", "51532", "51533", "51534", "51535", "51541", "51542", "51543", "51544", "51550", "51561", "51562", "51571", "51572", "51573", "51610", "51620", "51630", "51641", "51642", "51650", "51660", "51700", "52111", "52112", "52113", "52114", "52115", "52121", "52122", "52210", "52221", "52222", "52230", "52241", "52242", "52250", "52260", "52271", "52272", "52273", "52122", "52210", "52221", "52222", "52230", "52241", "52242", "52250", "52260", "52271", "52272", "52273", "52274", "52310", "52320", "52331", "52332", "52411", "52412", "52413", "52414", "52421", "52422", "52423", "52424", "52425", "52426", "52431", "52432", "52441", "52442", "52443", "52444", "52445", "52451", "52452", "52453", "52454", "52455", "52461", "52462", "52463", "52464", "52465", "52466", "52471", "52472", "52473", "5248A", "5248B", "5248C", "5248D", "5248E", "5248F", "5248G", "5248H", "52481", "52482", "52483", "52484", "52485", "52486", "52487", "52488", "52501", "52502", "52503", "52504", "52610", "52621", "52622", "52623", "52624", "52625", "52626", "52627", "52631", "52632", "52633", "52634", "52635", "52710", "52720", "52730", "52740", "55110", "55120", "55211", "55212", "55220", "55231", "55232", "55233", "55234", "55235", "55236", "55301", "55302", "55303", "55304", "55305", "55401", "55402", "55403", "55404", "55510", "55520", "60101", "60102", "60210", "60220", "60230", "60240", "60250", "60301", "60302", "61110", "61120", "61200", "62100", "62200", "62300", "63111", "63112", "63113", "63121", "63122", "63210", "63220", "63230", "6330A", "6330B", "63301", "63401", "63402", "64110", "64120", "64200", "65110", "65121", "65122", "65123", "65210", "65221", "65222", "65231", "65232", "65233", "66010", "66020", "66030", "67110", "67120", "67130", "67201", "67202", "70110", "70120", "70200", "70310", "70320", "71100", "71210", "71220", "71230", "71310", "71320", "71330", "71340", "71401", "71402", "72100", "72200", "72300", "72400", "72500", "72601", "72602", "7310A", "7310B", "7310C", "7310D", "7310E", "7310F", "7310G", "7320A", "7320B", "7320C", "74111", "74112", "7412A", "7412B", "7412C", "7412D", "74122", "74123", "74130", "7414A", "7414B", "74141", "74142", "74144", "74145", "74146", "74150", "7420A", "7420B", "7420C", "7420D", "74201", "74202", "74203", "74204", "74205", "74301", "74302", "74401", "74402", "74500", "74601", "74602", "74701", "74702", "74811", "74812", "74813", "74821", "74822", "74831", "74832", "74833", "74834", "74835", "7484A", "7484B", "74841", "74842", "74843", "74844", "74845", "75111", "75112", "75121", "75122", "75123", "75124", "75131", "75132", "75133", "75134", "75135", "75136", "75137", "75140", "75210", "75220", "75230", "75240", "75250", "75300", "80101", "80102", "80211", "80212", "80220", "80301", "80302", "80303", "80410", "80421", "80422", "85111", "85112", "85113", "85114", "85115", "8512A", "8512B", "85121", "85122", "85124", "85125", "85126", "85127", "85130", "8514A", "8514B", "8514C", "8514D", "85141", "85142", "85144", "85200", "85310", "8532A", "8532B", "90001", "90002", "90003", "91111", "91112", "91113", "91120", "91200", "91310", "91320", "91330", "92110", "92120", "92130", "92200", "9231A", "9231B", "9231C", "9231D", "9231E", "9231F", "9231G", "92320", "92330", "92341", "92342", "92343", "92344", "9240A", "9240B", "9240C", "92510", "92520", "92530", "92611", "92612", "92613", "92614", "92615", "92616", "9262A", "9262B", "9262C", "92621", "92623", "92710", "92721", "92722", "93011", "93012", "93021", "93022", "93023", "93024", "93030", "93041", "93042", "93050", "95000", "99000"};
        int i = 0;
        while (i < codiceatt.length) {
            if (codatt.equals(codiceatt[i])) {
                trovato = true;
                break;
            }
            ++i;
        }
        return trovato;
    }

    public static boolean esisteProvincia(String prov) {
        boolean trovato = false;
        String[] provincia = new String[]{"AG", "AL", "AN", "AO", "AR", "AP", "AT", "AV", "BA", "BL", "BN", "BG", "BO", "BZ", "BS", "BR", "CA", "CL", "CB", "CE", "CT", "CZ", "CH", "CO", "CS", "CR", "CN", "EN", "FE", "FI", "FG", "FO", "FR", "GE", "GO", "GR", "IM", "IS", "AQ", "SP", "LT", "LE", "LI", "LU", "MC", "MN", "OR", "MS", "MT", "ME", "MI", "MO", "NA", "NO", "NU", "PD", "PA", "BI", "PR", "PV", "PG", "PS", "PE", "PC", "PI", "PT", "PN", "PZ", "RG", "RA", "RC", "RE", "RI", "RM", "RO", "SA", "SS", "SV", "SI", "SR", "SO", "TA", "TE", "TR", "TO", "TP", "TN", "TV", "TS", "UD", "VA", "VE", "VC", "VR", "VI", "VT", "KR", "LC", "LO", "PO", "RN", "VB", "VV", "FM", "PL", "ZA", "FU", "EE", "FC", "PU"};
        int i = 0;
        while (i < provincia.length) {
            if (prov.equals(provincia[i])) {
                trovato = true;
                break;
            }
            ++i;
        }
        return trovato;
    }

    public static boolean esisteQualificaINPDAP(String codice) {
        String[] codiciINPDAP = new String[]{"01000D0097", "0902019222", "01000D0482", "0902018213", "01000D0163", "0902018226", "01000D0484", "0902017225", "0100SD0033", "0902017237", "0100SD0034", "0902016224", "0100SD0035", "0902015238", "0100SD0036", "0902014324", "0100SD0597", "0902015212", "0100SD0074", "0902014211", "0100SD0073", "0902014230", "0100SD0072", "0902013231", "0100SD0598", "0902013210", "0100SD0049", "0902013216", "0100SD0048", "0902013214", "0100SD0047", "0902017534", "0100SD0599", "09020D0534", "0100SD0039", "0902014327", "0100SD0038", "0902014838", "0100SD0037", "0902000215", "0100SD0600", "0902000180", "0100SD0013", "09030D0554", "0100SD0012", "09030D0219", "0100SD0011", "09030D0221", "0100SD0601", "09030D0220", "0100SD0016", "09030D0218", "0100SD0015", "09030D0524", "0100SD0014", "09030D0217", "0100SD0602", "09030D0229", "0100SD0042", "09030D0525", "0100SD0041", "09030D0228", "0100SD0040", "09030D0526", "0100SD0603", "09030D0223", "0100SD0066", "09030D0527", "0100SD0065", "09030D0302", "0100SD0064", "09030D0528", "0100SD0604", "09030D0233", "0100SD0483", "09030D0529", "0100S18023", "09030D0232", "0100S16020", "09030D0530", "0100S14056", "09030D0239", "0100S13052", "09030D0531", "0100S16021", "09030D0227", "0100S14054", "09030D0532", "0100S16022", "0903019312", "0100S14055", "0903019222", "0100S16019", "0903018213", "0100S14053", "0903018226", "0100S13051", "0903017225", "0100S00062", "0903017237", "0100PD0010", "0903016224", "0100PD0009", "0903015238", "0100PD0605", "0903014324", "0100PD0046", "0903015212", "0100PD0045", "0903014211", "0100PD0606", "0903014230", "0100PD0004", "0903013231", "0100PD0003", "0903013210", "0100PD0607", "0903013236", "0100PD0044", "0903013234", "0100PD0043", "0903014327", "0100PD0608", "0903014838", "0100P16006", "0903000235", "0100P00062", "0903000180", "0100TD0002", "09040D0189", "0100TD0001", "09040E0245", "0100TD0609", "09040E0535", "0100TD0071", "09040D0194", "0100TD0070", "09040E0244", "0100TD0610", "09040E0252", "0100TD0068", "09040E0536", "0100TD0067", "09040E0251", "0100TD0611", "09040E0537", "0100T18025", "09040E0249", "0100T16024", "09040E0538", "0100T18027", "09040E0248", "0100T16026", "09040E0539", "0100T14050", "09040E0243", "0100T14007", "09040E0540", "0100T14063", "09040E0242", "0100T13059", "09040E0541", "0100T13660", "09040E0255", "0100T12057", "09040E0542", "0100T12058", "09040E0254", "0100T11008", "09040E0543", "0100T00062", "0904019246", "0100AD0032", "0904019250", "0100AD0031", "0904018185", "0100AD0612", "0904018182", "0100A18029", "0904019247", "0100A16028", "0904018241", "0100A14005", "0904018253", "0100A13018", "0904017256", "0100A12017", "0904017268", "0100A11030", "0904016192", "0100A00062", "0904015191", "0100000061", "0904014201", "02000D0097", "0904015198", "02000D0077", "0904014197", "02000D0078", "0904014280", "02000D0079", "0904013259", "02000D0080", "0904013181", "02000D0584", "0904013179", "02000D0585", "0904013257", "02000D0586", "0904000240", "02000D0496", "0904000180", "02000D0473", "09050D0188", "02000D0472", "09050D0189", "02000D0084", "09050D0274", "02000D0481", "09050D0511", "02000D0480", "09050D0194", "02000D0075", "09050E0267", "02000E0083", "09050E0558", "02000E0076", "09050E0266", "0200046000", "09050E0559", "0200045000", "09050D0572", "0200043000", "09050D0573", "0200042000", "09050D0574", "0200040000", "09050D0575", "0200034000", "09050D0576", "0200032000", "09050D0577", "0200030000", "09050D0578", "0200027000", "09050D0579", "0200025000", "09050D0590", "0200023000", "09050D0591", "0200000061", "09050D0592", "03000D0097", "09050D0593", "03000D0089", "0905019580", "03000D0397", "0905018581", "03000D0093", "0905018582", "03000D0090", "0905017268", "03000D0398", "0905016192", "03000D0094", "0905015198", "03000D0077", "0905015191", "03000D0078", "0905014201", "03000D0079", "0905014197", "03000D0080", "0905014280", "03000E0083", "0905013259", "03000E0076", "0905013181", "0300012088", "0905013560", "0300012091", "0905013561", "0300013088", "0905000180", "0300013091", "0905000061", "0300013087", "09070D0359", "0300014088", "09070D0292", "0300014092", "09070D0191", "0300014087", "09070D0358", "0300016092", "09070D0545", "0300016396", "09070D0357", "0300016087", "09070D0356", "0300018086", "09070D0546", "0300018092", "09070D0290", "0300018396", "09070D0547", "0300019086", "09070D0289", "0300019085", "09070D0548", "0300019396", "09070D0288", "0300006086", "09070D0549", "0300006085", "09070D0286", "0300000061", "09070D0550", "04010D0102", "09070D0285", "04010D0103", "09070D0551", "04010D0485", "09070D0283", "04010D0104", "09070D0552", "04010D0097", "09070D0282", "04010D0098", "09070D0553", "04010D0095", "0907019355", "04010D0100", "0907019287", "04010D0099", "0907018284", "0401052486", "0907018281", "0401052487", "10010D0298", "0401051488", "10010D0297", "0401051489", "10010D0220", "0401058000", "10010D0218", "0401050000", "10010D0524", "0401049000", "10010D0217", "0401057000", "10010D0229", "0401045000", "10010D0525", "0401043000", "10010D0228", "0401042000", "10010D0526", "0401056000", "10010D0223", "0401038490", "10010D0527", "0401038491", "10010D0302", "0401037492", "10010D0528", "0401037493", "10010D0233", "0401036494", "10010D0529", "0401036495", "10010D0232", "0401055000", "10010D0530", "0401034000", "10010D0239", "0401032000", "10010D0531", "0401054000", "10010D0227", "0401028000", "10010D0532", "0401027000", "1001019312", "0401025000", "1001019222", "0401053000", "1001018213", "0401000061", "1001018226", "0401000096", "1001017225", "04030D0104", "1001017830", "04030D0097", "1001017556", "04030D0100", "1001016305", "04030D0099", "1001015306", "0403043000", "1001014307", "0403042000", "1001015326", "0403056000", "1001014325", "0403036000", "1001014308", "0403034000", "1001013300", "0403032000", "1001013299", "0403054000", "1001013301", "0403028000", "1001013294", "0403027000", "1001017831", "0403025000", "1001014327", "0403053000", "1001017832", "0403000061", "1001014833", "04040D0680", "1001000840", "04040D0681", "1001000841", "04040D0682", "1001000348", "04040D0683", "1001000180", "0404051000", "10020D0328", "0404050000", "10020D0323", "0404049000", "10020D0317", "0404048000", "10020D0218", "0404043000", "10020D0524", "0404042000", "10020D0217", "0404040000", "10020D0229", "0404036000", "10020D0525", "0404034000", "10020D0228", "0404032000", "10020D0526", "0404030000", "10020D0223", "0404025000", "10020D0527", "0404023000", "10020D0302", "0404045580", "10020D0528", "0404043581", "10020D0233", "0404042192", "10020D0529", "0404040582", "10020D0232", "0404034268", "10020D0530", "0404032192", "10020D0239", "0404030191", "10020D0531", "0404027259", "10020D0227", "0404025181", "10020D0532", "0404023561", "1002019312", "0404000061", "1002019222", "04050D0104", "1002018213", "04050D0097", "1002018226", "04050D0098", "1002017225", "04050D0095", "1002017830", "04050D0100", "1002017556", "04050D0099", "1002016224", "0405052000", "1002015238", "0405051000", "1002014324", "0405050000", "1002015326", "0405049000", "1002014325", "0405048000", "1002014308", "0405097000", "1002013319", "0405046000", "1002013318", "0405045000", "1002013320", "0405043000", "1002013321", "0405042000", "1002017831", "0405040000", "1002014327", "0405036000", "1002017832", "0405034000", "1002014833", "0405032000", "1002000840", "0405030000", "1002000841", "0405028000", "1002000348", "0405027000", "1002000180", "0405025000", "10030D0330", "0405023000", "10030D0329", "0405000061", "10030D0334", "04060D0102", "10030D0346", "04060D0103", "10030D0562", "04060D0485", "10030D0345", "04060D0164", "10030D0331", "0406047000", "10030D0563", "0406042000", "10030D0344", "0406040000", "10030D0564", "0406034000", "10030D0565", "0406032000", "10030D0566", "0406030000", "10030D0342", "0406022000", "10030D0567", "0406042324", "10030D0568", "0406040211", "10030D0569", "0406034561", "10030D0570", "0406032561", "10030D0571", "0406000061", "10030D0514", "0406000096", "10030D0523", "04070D0102", "10030D0533", "04070D0103", "10030D0544", "04070D0485", "1003019343", "04070D0097", "1003019341", "04070D0100", "1003018354", "04070D0099", "1003018338", "04070D8000", "1003017335", "04070D7000", "1003017830", "04070D6000", "1003017556", "04070DA000", "1003016332", "0407052000", "1003015347", "0407051000", "1003014333", "0407050000", "1003015350", "0407049000", "1003014349", "0407057000", "1003014308", "04070C8000", "1003013337", "04070C7000", "1003013351", "0407097000", "1003013352", "0407046000", "1003013353", "0407045000", "1003017831", "0407043000", "1003014336", "0407042000", "1003017832", "0407056000", "1003014833", "04070B8000", "1003000840", "04070B7000", "1003000841", "04070BA000", "1003000348", "0407038000", "1003000180", "0407037000", "10040D0340", "0407036000", "10040D0339", "0407034000", "10040D0334", "0407032000", "10040D0346", "0407054000", "10040D0562", "04070A8000", "10040D0345", "04070A7000", "10040D0331", "04070A6000", "10040D0563", "04070A5000", "10040D0344", "0407028000", "10040D0564", "0407027000", "10040D0565", "0407025000", "10040D0566", "0407053000", "10040D0342", "04070PL900", "10040D0567", "04070PL901", "10040D0568", "04070PL902", "10040D0569", "04070PL903", "10040D0570", "04070PL904", "10040D0571", "04070PL905", "10040D0514", "04070PL906", "10040D0523", "04070PL907", "10040D0533", "04070PL908", "10040D0544", "04070PL909", "1004019343", "04070PL910", "1004019341", "04070PL911", "1004018354", "04070PL912", "1004018338", "04070PL913", "1004017335", "04070PL914", "1004017830", "04070PL915", "1004017556", "0407000061", "1004016332", "0407000096", "1004015347", "04080D0102", "1004014333", "04080D0103", "1004015350", "04080D0485", "1004014349", "04080E0083", "1004014308", "04080E0800", "1004013337", "04080D0164", "1004013351", "04080E0801", "1004013352", "04080E0076", "1004013353", "04080D0679", "1004017831", "04080DE000", "1004014336", "0408057000", "1004017832", "04080CE000", "1004014833", "0408056000", "1004000840", "04080BE000", "1004000841", "0408054000", "1004000348", "0408053000", "1004000180", "0408014646", "10050D0359", "0408016132", "10050D0292", "0408014143", "10050D0191", "0408014154", "10050D0358", "0408014155", "10050D0545", "0408013159", "10050D0357", "0408013498", "10050D0356", "0408013499", "10050D0546", "0408012119", "10050D0290", "0408012117", "10050D0547", "0408098701", "10050D0289", "0408016192", "10050D0548", "0408015191", "10050D0288", "0408040114", "10050D0549", "0408030114", "10050D0286", "04080D0497", "10050D0550", "0408000061", "10050D0285", "0408000096", "10050D0551", "04090D0102", "10050D0283", "04090D0103", "10050D0552", "04090D0485", "10050D0282", "04090D0100", "10050D0553", "04090D0099", "1005019355", "04090D0715", "1005019287", "04090D0716", "1005018284", "0409000717", "1005018281", "0409000718", "12010D0388", "0409000719", "12010D0389", "0409000720", "12010D0387", "0409000721", "12010D0391", "0409000722", "12010D0390", "0409000723", "12010D0394", "0409000724", "12020D0364", "0409000725", "12020D0373", "0409000726", "12020D0365", "0409000727", "12020D0360", "0409000728", "12020D0366", "0409000729", "12020D0361", "0409000730", "12020D0367", "0409000731", "12020D0362", "0409000732", "12020D0376", "04090D0861", "12030D0374", "04090D0862", "12030D0373", "0409000061", "12030D0375", "0409000096", "12030D0369", "05010D0478", "12030D0371", "05010D0479", "12030D0368", "05010D0077", "12030D0370", "05010D0078", "12030D0362", "05010D0079", "12030D0376", "05010D0594", "12040D0381", "05010D0080", "12040D0380", "05010D0497", "12040D0379", "05010E0083", "12040D0378", "05010E0076", "12040D0385", "0501044000", "12040D0377", "0501043000", "12040D0384", "0501042000", "12040D0383", "0501041000", "12040D0382", "0501040000", "12050D0386", "0501035000", "12050D0365", "0501034000", "12050D0392", "0501032000", "12050D0393", "0501030000", "12050D0388", "0501024000", "12050D0389", "0501023000", "12050D0387", "0501000061", "12050D0391", "06010D0077", "12050D0390", "06010D0078", "12050D0395", "06010D0079", "12050D0394", "06010D0080", "13010D0106", "06010E0083", "13010D0109", "06010E0076", "13010D0107", "0601043115", "13010D0108", "0601043114", "13010D0110", "0601042115", "13020D0111", "0601042114", "13020D0112", "0601040115", "13020D0113", "0601040114", "14010D0097", "0601034115", "14010D0164", "0601032115", "1401043091", "0601032114", "1401034404", "0601030115", "1401032404", "0601030114", "1401027404", "0601025114", "1401025404", "0601023114", "1401000061", "0601000061", "1402043000", "0601000116", "1402042000", "06040D0077", "1402040000", "06040D0078", "1402034000", "06040D0079", "1402032000", "06040D0080", "1402030000", "0604044000", "1402024000", "0604043000", "14030D0091", "0604042000", "14030D0663", "0604041000", "14030D0433", "0604040000", "1403043091", "0604035000", "14030D0018", "0604034000", "1403040181", "0604032000", "1403034269", "0604030000", "1403000061", "0604024000", "14040D0091", "0604023000", "14040D0664", "0604000061", "14040D0665", "07010D0158", "14040D0433", "0701016132", "14040D0663", "0701016135", "1404044091", "0701014154", "1404043091", "0701014155", "1404042091", "0701014143", "1404041018", "0701016630", "1404040018", "0701016638", "1404035181", "0701014634", "1404034181", "0701014656", "1404032181", "0701014714", "140403S269", "0701014646", "1404027269", "0701014647", "1404025269", "0701014648", "1404000061", "0701014649", "14050D0091", "0701013159", "14050D0164", "0701013661", "1405043091", "0701013498", "1405034404", "0701013499", "1405027404", "0701012117", "1405000061", "0701012119", "14060D0666", "0701012125", "14060D0667", "0701012141", "14060D0668", "0701012700", "14060D0669", "0701098701", "14060D0670", "0701098702", "1406043091", "0701011121", "1406042671", "0701016623", "1406040672", "0701016624", "1406034404", "0701014628", "1406027404", "0701014629", "1406000061", "0701014627", "14070D0091", "0701013703", "14070D0663", "0701013652", "14070D0433", "0701013655", "1407043091", "0701012614", "1407042018", "0701012616", "1407040181", "0701012622", "1407034269", "0701012626", "1407032269", "0701011618", "1407030269", "0701012704", "1407020269", "0701098705", "1407000061", "0701098706", "14080D0104", "0701016139", "14080D0164", "0701014138", "1408043091", "0701016134", "1408034404", "0701016136", "1408027030", "0701014152", "1408000061", "0701014156", "27010D0097", "0701014144", "27010D0089", "0701016133", "27010D0397", "0701016137", "27010D0093", "0701014153", "27010D0090", "0701014157", "27010D0398", "0701014145", "27010D0094", "0701016631", "27010D0188", "0701016632", "27010D0164", "0701016633", "2701011165", "0701016639", "27010E0083", "0701016640", "2701012076", "0701016641", "2701012088", "0701014635", "2701012091", "0701014636", "2701013088", "0701014637", "2701013091", "0701014643", "2701013087", "0701014644", "2701014088", "0701014645", "2701014092", "0701014657", "2701014087", "0701014658", "2701016092", "0701014659", "2701016396", "0701013160", "2701016087", "0701013662", "2701018086", "0701013650", "2701018092", "0701013653", "2701018396", "0701012118", "2701019086", "0701012120", "2701019085", "0701012126", "2701019396", "0701012142", "2701006086", "0701012707", "2701006085", "0701098708", "2701000061", "0701098709", "27020D0077", "0701011124", "27020D0078", "0701013710", "27020D0079", "0701013651", "27020D0080", "0701013654", "2702005000", "0701012613", "2702004000", "0701012615", "2702006000", "0701012621", "27020E0083", "0701012625", "27020E0076", "0701012711", "2702045000", "0701098712", "2702043000", "0701098713", "2702042000", "0701011617", "2702040000", "07020D0158", "2702036000", "0702018500", "2702034000", "0702016501", "2702032000", "0702014502", "2702030000", "0702013504", "2702028000", "0702013159", "2702027000", "0702013503", "2702025000", "0702011121", "2702023000", "0702011122", "27020D0402", "0702012117", "27020D0401", "0702018505", "27020D0082", "0702016506", "27020D0081", "0702014507", "27020D0403", "0702018508", "2702000061", "0702016509", "27040D0164", "0702014510", "2704000405", "0702011124", "2704001000", "0702011123", "2704007000", "0702013160", "2704011000", "0702012118", "2704012000", "08000D0173", "2704013000", "08000D0172", "2704014000", "08000D0175", "2704016000", "08000D0174", "2704000061", "08000D0169", "27050D0164", "08000D0168", "2705085000", "08000D0167", "2705084000", "08000D0166", "2705083000", "08000D0177", "2705081000", "08000D0176", "2705080000", "08000D0178", "2705079000", "08000D0162", "2705078000", "08000D0677", "2705077000", "08000D0673", "2705076000", "08000D0163", "2705075000", "08000D0079", "2705074000", "08000D0080", "2705073000", "08000E0674", "2705000061", "08000E0675", "27060D0164", "08000D0170", "27060D0165", "08000D0171", "27060P1000", "0800000676", "27060P2000", "0800063000", "27060P3000", "0800062000", "27060P4000", "0800061000", "27060P5000", "0800060000", "27060P6000", "0800059000", "27060P7000", "0800052000", "27060P8000", "0800051000", "2706046000", "0800050000", "2706045000", "0800049000", "2706043000", "0800048000", "2706042000", "0800046000", "2706040000", "0800045000", "2706036000", "0800043000", "2706034000", "0800042000", "2706032000", "0800040000", "2706030000", "0800036000", "2706028000", "0800034000", "2706027000", "0800032000", "2706025000", "0800030000", "2706023000", "0800000061", "2706000061", "09010D0399", "27070D0077", "09010D0400", "27070D0078", "09010D0189", "27070D0079", "09010E0190", "27070D0080", "09010D0274", "2707044000", "09010D0511", "2707043000", "09010E0196", "2707042000", "09010E0512", "2707040000", "09010D0194", "2707033000", "09010E0195", "2707032000", "09010E0209", "2707030000", "09010E0513", "2707026000", "09010D0203", "2707025000", "09010D0515", "2707023000", "09010D0202", "2707000061", "09010D0516", "27080D0097", "09010E0206", "27080D0077", "09010E0517", "27080D0078", "09010E0205", "27080D0079", "09010E0518", "27080D0080", "09010D0187", "27080E0083", "09010D0519", "2708090000", "09010D0186", "2708087000", "09010D0520", "2708096000", "09010D0184", "2708086000", "09010D0521", "2708091000", "09010D0183", "2708089000", "09010D0522", "2708088000", "0901019207", "2708072000", "0901019204", "2708071000", "0901018185", "2708000061", "0901018182", "28020D0469", "0901017836", "28020D0164", "0901017268", "2802064000", "0901016192", "2802065000", "0901015191", "2802066000", "0901014201", "2802067000", "0901015198", "2802068000", "0901014197", "2802069000", "0901014280", "2802070000", "0901013259", "2802000061", "0901013181", "28030D0433", "0901013179", "28030D0164", "0901013257", "2803000476", "0901000240", "2803000477", "0901000180", "2803023000", "09020D0554", "2803025000", "09020D0219", "2803027000", "09020D0221", "2803030000", "09020D0220", "2803032000", "09020D0218", "2803034000", "09020D0524", "2803040000", "09020D0217", "2803042000", "09020D0229", "2803043000", "09020D0525", "2803048000", "09020D0228", "2803049000", "09020D0526", "2803000061", "09020D0223", "28040D0433", "09020D0527", "28040D0164", "09020D0302", "2804018405", "09020D0528", "2804016405", "09020D0233", "2804018000", "09020D0529", "2804016000", "09020D0232", "2804014000", "09020D0530", "2804013000", "09020D0239", "2804012000", "09020D0531", "2804011000", "09020D0227", "2804007000", "09020D0532", "2804001000", "0902019312", "2804000061", "0701011122", "2801000431", "0701011123", "2801000432", "0701011619", "2801000434", "0701011620", "2801000435", "0701013503", "2801000436", "0701016146", "2801000437", "0701016147", "2801000438", "0701016148", "2801000439", "0701016149", "2801000440", "0701016150", "2801000441", "0701016151", "2801000442", "1001000316", "2801000443", "1002000316", "2801000444", "1003000316", "2801000445", "1004000316", "2801000446", "2801000061", "2801000447", "2801000407", "2801000448", "2801000408", "2801000449", "2801000409", "2801000450", "2801000410", "2801000451", "2801000411", "2801000452", "2801000412", "2801000453", "2801000413", "2801000454", "2801000414", "2801000455", "2801000415", "2801000456", "2801000416", "2801000457", "2801000417", "2801000458", "2801000418", "2801000459", "2801000419", "2801000460", "2801000420", "2801000462", "2801000421", "2801000463", "2801000422", "2801000464", "2801000423", "2801000465", "2801000424", "2801000466", "2801000425", "2801000467", "2801000426", "2801000468", "2801000427", "04040D0098", "2801000428", "04040D0164", "2801000429", "28010D0164", "2801000430", "28010D0433", "9999999999"};
        int i = 0;
        while (i < codiciINPDAP.length) {
            if (codiciINPDAP[i].equals(codice)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String format(double valore) {
        String out = "";
        String s = "";
        String meno = "";
        int fattore = 0;
        int i = 0;
        try {
            s = String.valueOf(valore);
            if (s.substring(s.length() - 2, s.length()).equals(".0")) {
                int vi = (int)valore;
                out = String.valueOf(vi);
            } else {
                if (s.charAt(0) == '-') {
                    s = s.substring(1);
                    meno = "-";
                }
                if ((i = s.indexOf("E")) > 0) {
                    fattore = Integer.parseInt(s.substring(i + 1));
                    out = String.valueOf(meno) + s.charAt(0) + s.substring(2, fattore + 2) + (fattore + 2 == i ? "" : String.valueOf(',') + s.substring(fattore + 2, i));
                } else {
                    out = String.valueOf(valore).replace('.', ',');
                }
            }
        }
        catch (Exception e) {
            out = String.valueOf(meno) + s.charAt(0) + s.substring(2, i) + Util.formNum(2 + fattore - i, 0);
        }
        return out;
    }

    public static String formattaN(String st) {
        String st1 = st.trim().replace(',', '.');
        try {
            new Float(st1);
        }
        catch (NumberFormatException e) {
            st1 = "E" + st1;
            return st1;
        }
        return st1;
    }

    public static String formNum(int l, int i) {
        return Util.formNum(l, String.valueOf(i));
    }

    public static String formNum(int l, long i) {
        return Util.formNum(l, String.valueOf(i));
    }

    public static String formNum(int l, String si) {
        int li = si.length();
        if (li == l) {
            return si;
        }
        if (li < l) {
            char[] vchar = new char[l];
            int c = 0;
            while (c < l) {
                vchar[c] = c < l - li ? 48 : (int)si.charAt(c - (l - li));
                ++c;
            }
            return new String(vchar);
        }
        return si.substring(0, l);
    }

    public static String formStr(int l, String valore, char riemp) {
        int li;
        int lstr;
        String rc = "";
        if (valore == null) {
            valore = "";
        }
        if ((lstr = l - (li = valore.length())) == 0) {
            rc = valore;
        } else if (lstr > 0) {
            char[] vchar = new char[lstr];
            int i = 0;
            while (i < lstr) {
                vchar[i] = 32;
                ++i;
            }
            String bb = new String(vchar);
            if (riemp == 'R') {
                rc = String.valueOf(valore) + bb;
            }
            if (riemp == 'L') {
                rc = String.valueOf(bb) + valore;
            }
        } else {
            if (riemp == 'R') {
                rc = valore.substring(0, l);
            }
            if (riemp == 'L') {
                rc = valore.substring(li - l, li);
            }
        }
        return rc;
    }

    public static String getDataCorrente() {
        Date dateNow = new Date();
        SimpleDateFormat dfGiorno = new SimpleDateFormat("dd");
        SimpleDateFormat dfMese = new SimpleDateFormat("MM");
        SimpleDateFormat dfAnno = new SimpleDateFormat("yyyy");
        String data = String.valueOf(dfGiorno.format(dateNow)) + dfMese.format(dateNow) + dfAnno.format(dateNow);
        return data;
    }

    public static boolean isData1compresatraData2eData3(String data1, String data2, String data3) {
        int dataInizio = 0;
        int dataFine = 0;
        int dataCorrente = 0;
        if (data1.length() == 8) {
            dataCorrente = Integer.parseInt(String.valueOf(data1.substring(4, 8)) + data1.substring(2, 4) + data1.substring(0, 2));
        }
        if (data2.length() == 8) {
            dataInizio = Integer.parseInt(String.valueOf(data2.substring(4, 8)) + data2.substring(2, 4) + data2.substring(0, 2));
        }
        if (data3.length() == 8) {
            dataFine = Integer.parseInt(String.valueOf(data3.substring(4, 8)) + data3.substring(2, 4) + data3.substring(0, 2));
        }
        return dataCorrente >= dataInizio && dataCorrente <= dataFine;
    }

    public static boolean isData1minoreUgualeData2(String data1, String data2) {
        int dataInizio = 0;
        int dataFine = 0;
        if (data1.length() == 8) {
            dataInizio = Integer.parseInt(String.valueOf(data1.substring(4, 8)) + data1.substring(2, 4) + data1.substring(0, 2));
        }
        if (data2.length() == 8) {
            dataFine = Integer.parseInt(String.valueOf(data2.substring(4, 8)) + data2.substring(2, 4) + data2.substring(0, 2));
        }
        return dataInizio <= dataFine;
    }

    public static boolean isDiffMaggioreDi1(long a, long b) {
        return Math.abs(a - b) > 1L;
    }

    public static boolean isInside(double i, String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            int p = item.indexOf("-");
            if (p > 0) {
                double da = Double.valueOf(item.substring(0, p));
                double a = Double.valueOf(item.substring(p + 1, item.length()));
                if (!(da <= i) || !(i <= a)) continue;
                return true;
            }
            if (Double.valueOf(item) != i) continue;
            return true;
        }
        return false;
    }

    public static boolean isInside(int i, String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            int p = item.indexOf("-");
            if (p > 0) {
                int da = Integer.parseInt(item.substring(0, p));
                int a = Integer.parseInt(item.substring(p + 1, item.length()));
                if (da > i || i > a) continue;
                return true;
            }
            if (Integer.parseInt(item) != i) continue;
            return true;
        }
        return false;
    }

    public static boolean isInside(long i, String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            int p = item.indexOf("-");
            if (p > 0) {
                long da = Long.parseLong(item.substring(0, p));
                long a = Long.parseLong(item.substring(p + 1, item.length()));
                if (da > i || i > a) continue;
                return true;
            }
            if (Long.parseLong(item) != i) continue;
            return true;
        }
        return false;
    }

    public static int[] generaValoriDaRange(String s) {
        Vector<Integer> v = new Vector<Integer>();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            int p = item.indexOf("-");
            if (p > 0) {
                int da = Integer.parseInt(item.substring(0, p));
                int a = Integer.parseInt(item.substring(p + 1, item.length()));
                int j = da;
                while (j <= a) {
                    v.add(new Integer(j));
                    ++j;
                }
                continue;
            }
            v.add(new Integer(Integer.parseInt(item)));
        }
        int[] out = new int[v.size()];
        int i = 0;
        while (i < v.size()) {
            out[i] = (Integer)v.elementAt(i);
            ++i;
        }
        return out;
    }

    public static boolean isInside(String i, String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String elem = st.nextToken();
            if (!elem.equals(i)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNonValorizzato(String valore) {
        String s = valore.trim();
        if (s.equals("")) {
            return true;
        }
        int len = s.length();
        int i = 0;
        while (i < len) {
            if (s.charAt(i) != '0') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNumericoAssoluto(String s) {
        if (s.length() == 0) {
            return false;
        }
        try {
            Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        char[] sArray = s.toCharArray();
        int i = 0;
        while (i < sArray.length) {
            if (sArray[i] < '0' || sArray[i] > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAlfabetico(String s) {
        if (s.length() == 0) {
            return false;
        }
        char[] sArray = s.toUpperCase().toCharArray();
        int i = 0;
        while (i < sArray.length) {
            if (sArray[i] < 'A' || sArray[i] > 'Z') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isUpperCase(String s) {
        return (s = s.replace('\u00df', 'S')).toUpperCase().equals(s);
    }

    public static long lire2euro(double in) {
        return Util.lire2euro(in, true);
    }

    public static long lire2euro(double in, boolean isMigliaia) {
        return (long)Util.lire2euro(in, 0, isMigliaia);
    }

    public static double lire2euro(double in, int decimali, boolean isMigliaia) {
        if (isMigliaia) {
            in *= 1000.0;
        }
        double ris = in / 1936.27;
        double divisore = Math.pow(10.0, decimali);
        return (double)Math.round(ris * divisore) / divisore;
    }

    public static String mills2Date(long theTime) {
        long ja;
        long julianDayOffset = 2440588L;
        int millisPerDay = 86400000;
        long gregorianCutover = -12219292800000L;
        long julian = 0L;
        julian = theTime >= 0L ? julianDayOffset + theTime / (long)millisPerDay : julianDayOffset + (theTime - (long)millisPerDay + 1L) / (long)millisPerDay;
        if (theTime >= gregorianCutover) {
            long jalpha = (long)(((double)(julian - 1867216L) - 0.25) / 36524.25);
            ja = julian + 1L + jalpha - (long)(0.25 * (double)jalpha);
        } else {
            ja = julian;
        }
        long jb = ja + 1524L;
        long jc = (long)Math.floor(6680.0 + ((double)(jb - 2439870L) - 122.1) / 365.25);
        long jd = (long)Math.floor((double)(365L * jc) + 0.25 * (double)jc);
        long je = (long)((double)(jb - jd) / 30.6001);
        int date = (int)(jb - jd - (long)(30.6001 * (double)je));
        int month = (int)je - 1;
        if (month > 12) {
            month -= 12;
        }
        int year = (int)(jc - 4715L);
        if (month > 2) {
            --year;
        }
        if (year <= 0) {
            year = 1 - year;
        }
        return String.valueOf(date) + "/" + month + "/" + year;
    }

    public static boolean numerico(String valore) {
        int ldopo;
        int lprima = Util.trimL(valore).length();
        if (lprima != (ldopo = Util.trimL(valore = valore.replace('-', ' ')).length()) && lprima - 1 != ldopo) {
            return false;
        }
        String v = Util.trimL(valore);
        if (v.equals("")) {
            return false;
        }
        if (v.length() == 1 && v.charAt(0) == ',') {
            return false;
        }
        if (v.charAt(0) == ',' || v.charAt(v.length() - 1) == ',') {
            return false;
        }
        if (v.indexOf(",") != v.lastIndexOf(",")) {
            return false;
        }
        char[] vchar = new char[v.length()];
        v.getChars(0, v.length(), vchar, 0);
        int i = 0;
        boolean out = true;
        while (out && i < v.length()) {
            if ((vchar[i] < '0' || vchar[i] > '9') && vchar[i] != ',') {
                out = false;
            }
            ++i;
        }
        return out;
    }

    public static boolean numericoTrim(String valore) throws NumberFormatException {
        block3: {
            try {
                valore = valore.trim();
                if (Double.valueOf(Util.trimL(valore).replace(',', '.')) != 0.0) break block3;
                return Util.trimL(valore).indexOf(" ") == -1 && Util.trimL(valore).indexOf("=") == -1;
            }
            catch (Exception e) {
                return false;
            }
        }
        return Util.trimL(valore).indexOf(" ") == -1 && Util.trimL(valore).indexOf("=") == -1;
    }

    public static String[] ordinaArray(String[] array, boolean az) {
        boolean cicla = true;
        while (cicla) {
            cicla = false;
            int i = 0;
            while (i < array.length - 1) {
                if (az ? array[i].compareTo(array[i + 1]) > 0 : array[i].compareTo(array[i + 1]) < 0) {
                    String appo = array[i];
                    array[i] = array[i + 1];
                    array[i + 1] = appo;
                    cicla = true;
                }
                ++i;
            }
        }
        return array;
    }

    /*
     * Unable to fully structure code
     */
    private static void quickSort(CollationKey[] a, int lo0, int hi0) {
        block5: {
            lo = lo0;
            hi = hi0;
            if (hi0 <= lo0) break block5;
            mid = a[(lo0 + hi0) / 2];
            ** GOTO lbl16
            {
                ++lo;
                do {
                    if (lo < hi0 && a[lo].compareTo(mid) < 0) continue block0;
                    while (hi > lo0 && a[hi].compareTo(mid) > 0) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    Util.swap(a, lo, hi);
                    ++lo;
                    --hi;
lbl16:
                    // 3 sources

                } while (lo <= hi);
            }
            if (lo0 < hi) {
                Util.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                Util.quickSort(a, lo, hi0);
            }
        }
    }

    public static String replaceString(String in, String da, String a) {
        int position = in.indexOf(da);
        String out = "";
        out = position >= 0 ? in.substring(0, position) + a + Util.replaceString(in.substring(position + da.length(), in.length()), da, a) : in;
        return out;
    }

    public static String restituisciDescrizioneCodAtt(String codice) {
        if (BaseTelem.getInstance().getDescCodAtt() == null) {
            try {
                BaseTelem.getInstance().riempiDescCodAtt();
            }
            catch (IOException e) {
                System.out.println("Errore nel caricamento dei Codici Attivit\u00e0");
            }
        }
        return BaseTelem.getInstance().getDescCodAtt(codice);
    }

    public static String restituisciDescrizioneCodUff(String codice) {
        if (BaseTelem.getInstance().getDescCodUff() == null) {
            try {
                BaseTelem.getInstance().riempiDescCodUff();
            }
            catch (IOException e) {
                System.out.println("Errore nel caricamento dei Codici Attivit\u00e0");
            }
        }
        return BaseTelem.getInstance().getDescCodUff(codice);
    }

    public static String restituisciCodUff(String descrizione) {
        if (BaseTelem.getInstance().getDescCodUff() == null) {
            try {
                BaseTelem.getInstance().riempiDescCodUff();
            }
            catch (IOException e) {
                System.out.println("Errore nel caricamento dei Codici Ufficio");
            }
        }
        return BaseTelem.getInstance().getCodUff(descrizione);
    }

    public static float restituisciValoreIntervallo(float valore, float[] tabella, float[] risultato) {
        int i = 0;
        while (i < tabella.length) {
            if (valore <= tabella[i]) {
                return risultato[i];
            }
            ++i;
        }
        return risultato[risultato.length - 1];
    }

    public static void sort(String[] dirList) {
        if (dirList != null && dirList.length > 0) {
            Collator collator = Collator.getInstance();
            CollationKey[] keys = new CollationKey[dirList.length];
            int i = 0;
            while (i < dirList.length) {
                keys[i] = collator.getCollationKey(dirList[i]);
                ++i;
            }
            Util.quickSort(keys, 0, dirList.length - 1);
            i = 0;
            while (i < dirList.length) {
                dirList[i] = keys[i].getSourceString();
                ++i;
            }
        }
    }

    public static void substituteString(char[] in, String r, int offset) {
        char[] a = r.toCharArray();
        if (offset + r.length() > in.length) {
            throw new StringIndexOutOfBoundsException(offset + r.length());
        }
        int i = offset;
        while (i < offset + a.length) {
            in[i] = r.charAt(i - offset);
            ++i;
        }
    }

    private static void swap(CollationKey[] a, int i, int j) {
        CollationKey T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    public static String trimL(String s) {
        int len = s.length();
        int st = 0;
        char[] value = s.toCharArray();
        while (st < len && value[st] <= ' ') {
            ++st;
        }
        return st > 0 || len < s.length() ? s.substring(st, len) : s;
    }

    public static String trimR(String s) {
        int len = s.length();
        int st = 0;
        char[] value = s.toCharArray();
        while (st < len && value[len - 1] <= ' ') {
            --len;
        }
        return st > 0 || len < s.length() ? s.substring(st, len) : s;
    }

    public static double valoreDouble(String valore) {
        double numD = 0.0;
        try {
            String str = new String();
            str = Util.trimL(valore).replace(',', '.');
            numD = Double.valueOf(str);
        }
        catch (Exception e) {
            System.out.println("Errore nel metodo valoreDouble Stringa:" + valore);
        }
        return numD;
    }

    public static float valoreFloat(String valore) {
        float numf = 0.0f;
        try {
            String str = new String();
            str = Util.trimL(valore).replace(',', '.');
            numf = Float.valueOf(str).floatValue();
        }
        catch (Exception e) {
            System.out.println("Errore nel metodo valoreDouble Stringa:" + valore);
        }
        return numf;
    }

    public static int valoreInt(String valore) {
        int numI = 0;
        try {
            numI = Integer.valueOf(Util.trimL(valore));
        }
        catch (Exception e) {
            System.out.println("Errore nel metodo valoreInt Stringa:" + valore);
        }
        return numI;
    }

    public static long valoreLong(String valore) {
        long numL = 0L;
        try {
            numL = Long.valueOf(Util.trimL(valore));
        }
        catch (Exception e) {
            System.out.println("Errore nel metodo valoreLong Stringa:" + valore);
        }
        return numL;
    }

    public static String versionWithoutPoint(String version) {
        StringTokenizer st = new StringTokenizer(version, ".");
        String token = "";
        while (st.hasMoreTokens()) {
            String appTok = Util.formNum(2, st.nextToken());
            token = String.valueOf(token) + appTok;
        }
        if (token.length() < 5) {
            token = String.valueOf(token) + Util.formNum(6 - token.length(), "");
        }
        return token;
    }

    public static String dateXML2Telem(String date) {
        if (date.length() != 10) {
            return "";
        }
        return String.valueOf(date.substring(8)) + date.substring(5, 7) + date.substring(0, 4);
    }

    public static boolean isVer1MagUgualeVer2(String ver1, String ver2) {
        StringTokenizer v1 = new StringTokenizer(ver1, ".");
        StringTokenizer v2 = new StringTokenizer(ver2, ".");
        String verString1 = "";
        String verString2 = "";
        int cicli = v1.countTokens() > v2.countTokens() ? v1.countTokens() : v2.countTokens();
        int i = 0;
        while (i < cicli) {
            verString1 = String.valueOf(verString1) + Util.formNum(3, v1.hasMoreTokens() ? v1.nextToken() : "0");
            verString2 = String.valueOf(verString2) + Util.formNum(3, v2.hasMoreTokens() ? v2.nextToken() : "0");
            ++i;
        }
        System.out.println(verString1.compareTo(verString2));
        return verString1.compareTo(verString2) >= 0;
    }

    public static int restituisciTipo(String codiceCampo, String modello) {
        int out = BaseTelem.getInstance().getControlli(modello).getFormato(codiceCampo);
        return out;
    }

    public static int restituisciTipoRecB(int dataIndex) {
        int out = BaseTelem.getInstance().getRecordBcontrolli().getFormatoAt(dataIndex - 1);
        return out;
    }
}

