/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.main;

import finanze.IDTE.studi2002.main.InterpreteRecordDGN;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class GestoreMessaggioErrore {
    private static StringBuffer diagnostici = null;
    private static Hashtable errori = null;
    private static String[] arr_str = null;
    private static Vector v_str = null;
    static Class class$finanze$IDTE$studi2002$main$GestoreMessaggioErrore;

    private static String decodificaGravitaErrore(String str) {
        int gravitaErrore = Integer.parseInt(str);
        switch (gravitaErrore) {
            case 4: {
                return "(*)";
            }
            case 8: {
                return "(**)";
            }
            case 14: {
                return "(***C)";
            }
            case 16: {
                return "(***)";
            }
        }
        return null;
    }

    private static String formattaMessaggio(String string, String[] gruppiCampi) {
        String messaggio;
        if (string == null) {
            return "Mancata corrispondenza fra il codice dell'errore ed il messaggio associato.";
        }
        int numeroTokens = 0;
        String[] tokens = new String[]{"##", "@@", "$$", "&&"};
        int[] indiciTokens = new int[4];
        int i = 0;
        while (i < tokens.length) {
            int indice = string.indexOf(tokens[i]);
            if (indice != -1) {
                ++numeroTokens;
                indiciTokens[i] = indice;
            }
            ++i;
        }
        if (numeroTokens == 0) {
            return string;
        }
        if (numeroTokens != gruppiCampi.length) {
            return "Incongruenza tra il numero di parametri presenti nel messaggio e i parametri presenti sul record del file DGN.";
        }
        i = 0;
        while (i < numeroTokens) {
            messaggio = GestoreMessaggioErrore.replaceString(string, tokens[i], gruppiCampi[i].trim());
            ++i;
        }
        return messaggio;
    }

    private static Hashtable getErrori() {
        if (errori == null) {
            try {
                Class<?> clazz = class$finanze$IDTE$studi2002$main$GestoreMessaggioErrore;
                if (clazz == null) {
                    try {
                        clazz = class$finanze$IDTE$studi2002$main$GestoreMessaggioErrore = Class.forName("finanze.IDTE.studi2002.main.GestoreMessaggioErrore");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                BufferedReader raf = new BufferedReader(new InputStreamReader(clazz.getResourceAsStream("ErroriStudi.TXT")));
                errori = new Hashtable();
                String record = raf.readLine();
                while (record != null) {
                    StringTokenizer st = new StringTokenizer(record, "*");
                    errori.put(st.nextToken(), st.nextToken());
                    record = raf.readLine();
                }
                raf.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return errori;
    }

    public static String[] interpretaRecordsDGN(String recordDGN, boolean isControlli) {
        String messaggio;
        diagnostici = new StringBuffer();
        v_str = new Vector();
        InterpreteRecordDGN ir = new InterpreteRecordDGN(recordDGN);
        String tipoErrore = ir.getTipoErrore();
        String record = tipoErrore.substring(3, 4).trim();
        String codiceStudio = tipoErrore.substring(4, 9).trim();
        String codiceAttivita = tipoErrore.substring(9, 14).trim();
        String progressivo = tipoErrore.substring(14, 16).trim();
        String gravitaErrore = GestoreMessaggioErrore.decodificaGravitaErrore(ir.getGravitaErrore());
        String codiceErrore = ir.getCodiceErrore();
        if (isControlli) {
            v_str.addElement(gravitaErrore);
        }
        v_str.addElement("Record tipo " + record);
        boolean flag = false;
        String str = "";
        if (codiceStudio != null && codiceStudio.trim().length() > 0) {
            flag = true;
            str = "Studio " + codiceStudio;
        }
        if (codiceAttivita != null && codiceAttivita.trim().length() > 0) {
            if (flag) {
                str = String.valueOf(str) + " - ";
            }
            flag = true;
            str = String.valueOf(str) + "Attivita' " + codiceAttivita;
        }
        if (progressivo != null && progressivo.trim().length() > 0) {
            if (flag) {
                str = String.valueOf(str) + " - ";
            }
            flag = true;
            str = String.valueOf(str) + "Progressivo " + progressivo;
        }
        if (flag) {
            v_str.addElement(str);
        }
        if ((messaggio = GestoreMessaggioErrore.formattaMessaggio((String)GestoreMessaggioErrore.getErrori().get(codiceErrore), ir.getGruppiCampiErrati())) != null) {
            v_str.addElement(messaggio);
        }
        v_str.addElement("\n");
        arr_str = new String[v_str.size()];
        int i = 0;
        while (i < v_str.size()) {
            GestoreMessaggioErrore.arr_str[i] = (String)v_str.elementAt(i);
            ++i;
        }
        return arr_str;
    }

    private static String replaceString(String src, String oldValue, String newValue) {
        int start = 0;
        int end = src.indexOf(oldValue);
        StringBuffer sb = new StringBuffer();
        while (end != -1) {
            sb.append(src.substring(start, end)).append(newValue);
            start = end;
            end = src.indexOf(oldValue, end + oldValue.length());
        }
        sb.append(src.substring(start + oldValue.length()));
        return sb.toString();
    }
}

