/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.zip.handlers;

import it.sogei.rcp.interfaces.IAbsolutePath;
import it.sogei.rcp.interfaces.IRelativePath;
import it.sogei.rcp.zip.exceptions.ZipException;
import it.sogei.rcp.zip.interfaces.IZipUtil;
import it.sogei.utilities.log4j.LogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Zip64
implements IZipUtil {
    static final int BUFFER = 4096;

    @Override
    public void compress(IRelativePath relativeZipFilePath, IRelativePath relativeInputFilePath) throws IOException, ZipException {
        this.compress(relativeZipFilePath, relativeInputFilePath, 1);
    }

    private void compress(IRelativePath relativeZipFilePath, IRelativePath relativeInputFilePath, int level) throws IOException, ZipException {
        int livello_comp;
        File infile = new File(relativeInputFilePath.getAbsolutePath());
        if (infile.exists() && !infile.isFile()) {
            String msg = String.valueOf(infile.getAbsolutePath()) + " non \u00e8 un file";
            LogUtil.log((Object)this, (int)4, (String)("(E) " + msg));
            throw new ZipException(msg);
        }
        File outfile = new File(relativeZipFilePath.getAbsolutePath());
        if (outfile.exists() && !outfile.isFile()) {
            String msg = String.valueOf(outfile.getAbsolutePath()) + " non \u00e8 un file";
            LogUtil.log((Object)this, (int)4, (String)("(E) " + msg));
            throw new ZipException(msg);
        }
        if (infile.equals(outfile)) {
            String msg = "Input e Output non possono essere uguali";
            LogUtil.log((Object)this, (int)4, (String)("(E) " + msg));
            throw new ZipException(msg);
        }
        String descrizione_liv_comp = null;
        if (level == 0) {
            livello_comp = 0;
            descrizione_liv_comp = " NO_COMPRESSION";
        } else if (level == 1) {
            livello_comp = 9;
            descrizione_liv_comp = "BEST_COMPRESSION";
        } else if (level == 2) {
            livello_comp = 1;
            descrizione_liv_comp = "BEST_SPEED";
        } else {
            livello_comp = -1;
            descrizione_liv_comp = "DEFAULT_COMPRESSION";
        }
        try {
            int count;
            long initTime = System.currentTimeMillis();
            FileOutputStream dest = new FileOutputStream(relativeZipFilePath.getAbsolutePath());
            CheckedOutputStream checksum = new CheckedOutputStream(dest, new Adler32());
            ZipArchiveOutputStream zipOutput = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(checksum));
            zipOutput.setUseZip64(Zip64Mode.Always);
            long size = infile.length();
            byte[] data = new byte[4096];
            FileInputStream fi = new FileInputStream(infile);
            BufferedInputStream origin = new BufferedInputStream(fi, 4096);
            String entryname = infile.getName();
            String msg = "Adding: " + entryname;
            LogUtil.log((Object)this, (int)2, (String)("(I) " + msg));
            ZipArchiveEntry entry = new ZipArchiveEntry(entryname);
            entry.setSize(size);
            entry.setMethod(8);
            zipOutput.setLevel(livello_comp);
            msg = "Livello di compressione applicato: " + descrizione_liv_comp;
            LogUtil.log((Object)this, (int)2, (String)("(I) " + msg));
            zipOutput.putArchiveEntry((ArchiveEntry)entry);
            while ((count = origin.read(data, 0, 4096)) != -1) {
                zipOutput.write(data, 0, count);
            }
            origin.close();
            zipOutput.closeArchiveEntry();
            zipOutput.close();
            long endTime = System.currentTimeMillis();
            msg = "Checksum: " + checksum.getChecksum().getValue();
            LogUtil.log((Object)this, (int)2, (String)("(I) " + msg));
            msg = "Original file lenght: " + infile.length();
            LogUtil.log((Object)this, (int)2, (String)("(I) " + msg));
            msg = "Zipped file lenght: " + outfile.length();
            LogUtil.log((Object)this, (int)2, (String)("(I) " + msg));
            float ratio = (1.0f - (float)outfile.length() / (float)infile.length()) * 100.0f;
            msg = "Compression ratio: " + Float.toString(ratio) + "%";
            LogUtil.log((Object)this, (int)2, (String)("(I) " + msg));
            msg = "Compression: " + Float.toString((float)infile.length() / (float)outfile.length());
            LogUtil.log((Object)this, (int)2, (String)("(I) " + msg));
            msg = "Time to execute: " + (endTime - initTime) + " ms.";
            LogUtil.log((Object)this, (int)2, (String)("(I) " + msg));
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.log((Object)this, (int)4, (String)("(E) " + e.getMessage()));
            throw new ZipException(e.getMessage());
        }
    }

    @Override
    public void compressMultiFiles(IRelativePath relativeZipFilePath, ArrayList<IRelativePath> relativeInputFilePaths) throws IOException, ZipException {
    }

    @Override
    public void uncompress(IRelativePath relativeZipFilePath, IRelativePath relativeOutputPath) throws IOException, ZipException {
        File infile = new File(relativeZipFilePath.getAbsolutePath());
        if (!infile.isFile()) {
            String msg = String.valueOf(infile.getAbsolutePath()) + " non \u00e8 un file";
            LogUtil.log((Object)this, (int)4, (String)("(E) " + msg));
            throw new ZipException(msg);
        }
        File outdir = new File(relativeOutputPath.getAbsolutePath());
        if (outdir.exists()) {
            String msg = String.valueOf(outdir.getAbsolutePath()) + " esiste gi\u00e0.";
            LogUtil.log((Object)this, (int)4, (String)("(E) " + msg));
            throw new ZipException(msg);
        }
        int numEntries = 0;
        byte[] data = new byte[4096];
        try {
            long initTime = System.currentTimeMillis();
            String entryname = infile.getName();
            String msg = "Fileinput name: " + entryname;
            LogUtil.log((Object)this, (int)2, (String)("(I) " + msg));
            ZipFile zipFile = new ZipFile(infile);
            msg = "Fileoutput name: " + relativeOutputPath;
            LogUtil.log((Object)this, (int)2, (String)("(I) " + msg));
            Enumeration entries = zipFile.getEntries();
            ZipArchiveEntry[] entry = new ZipArchiveEntry[1];
            while (entries.hasMoreElements()) {
                entry[0] = (ZipArchiveEntry)entries.nextElement();
                LogUtil.log((Object)this, (int)2, (String)("(I) Name of Extract file : " + entry[0].getName()));
                boolean isDir = entry[0].isDirectory();
                if (isDir) continue;
                LogUtil.log((Object)this, (int)2, (String)("(I) " + entry[0].getName() + " \u00e8 un file"));
                ++numEntries;
                FileOutputStream fos = new FileOutputStream(outdir);
                InputStream content = zipFile.getInputStream(entry[0]);
                try {
                    msg = "Entry name: " + entry[0].getName();
                    LogUtil.log((Object)this, (int)2, (String)("(I) " + msg));
                    msg = "Entry compressed size: " + entry[0].getCompressedSize();
                    LogUtil.log((Object)this, (int)2, (String)("(I) " + msg));
                    msg = "Entry uncompressed size: " + entry[0].getSize();
                    LogUtil.log((Object)this, (int)2, (String)("(I) " + msg));
                    BufferedOutputStream dest = new BufferedOutputStream(fos, 4096);
                    int count = 0;
                    while ((count = content.read(data, 0, 4096)) != -1) {
                        dest.write(data, 0, count);
                    }
                    dest.flush();
                    dest.close();
                }
                finally {
                    content.close();
                }
            }
            zipFile.close();
            if (numEntries > 1) {
                msg = "ERRORE: l'archivio contiene pi\u00f9 di un file";
                LogUtil.log((Object)this, (int)4, (String)("(E) " + msg));
                throw new ZipException(msg);
            }
            if (numEntries == 0) {
                msg = "ERRORE: l'archivio non contiene file";
                LogUtil.log((Object)this, (int)4, (String)("(E) " + msg));
                throw new ZipException(msg);
            }
            long endTime = System.currentTimeMillis();
            LogUtil.log((Object)this, (int)2, (String)("(I) " + msg));
            msg = "Processed " + numEntries + " entries";
            LogUtil.log((Object)this, (int)2, (String)("(I) " + msg));
            msg = "Time to execute: " + (endTime - initTime) + " ms.";
            LogUtil.log((Object)this, (int)2, (String)("(I) " + msg));
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.log((Object)this, (int)4, (String)("(E) " + e.getMessage()));
            throw new ZipException(e.getMessage());
        }
    }

    @Override
    public void add(IRelativePath relativeZipFilePath, IRelativePath relativeInputFilePath) throws IOException, ZipException {
    }

    @Override
    public int getEntriesNumber(IRelativePath relativeZipFilePath) throws IOException, ZipException {
        int n = 0;
        return n;
    }

    @Override
    public ArrayList<String> getEntriesNames(IRelativePath relativeZipFilePath) throws IOException, ZipException {
        ArrayList<String> filenamesList = new ArrayList<String>();
        relativeZipFilePath.getFileName();
        relativeZipFilePath.getAbsoluteFolderPath();
        return filenamesList;
    }

    @Override
    public void unZipArchivio(IAbsolutePath absoluteZipFilePath, IAbsolutePath absoluteOutputPath) throws IOException, ZipException {
    }
}

