/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.math.ecgroup;

import iaik.asn1.OCTET_STRING;
import iaik.security.ecc.ECCException;
import iaik.security.ecc.math.ecgroup.Coordinate;
import iaik.security.ecc.math.ecgroup.ProjectiveCoordinate;
import iaik.security.ecc.math.field.FieldElement;
import iaik.security.ecc.util.PointCoDec;
import iaik.security.ecc.util.PointFormatter;

public class AffineCoordinate
extends Coordinate
implements Cloneable {
    public String toString() {
        return "X: " + this.x_.toString() + "\nY: " + this.y_.toString();
    }

    public ProjectiveCoordinate toProjective() {
        FieldElement fieldElement = this.getX().getField().getONEelement();
        return new ProjectiveCoordinate(this.getX(), this.getY(), fieldElement);
    }

    public OCTET_STRING toASN1Object() {
        try {
            PointFormatter pointFormatter = PointFormatter.getInstance();
            PointCoDec pointCoDec = pointFormatter.getPointCodec();
            byte[] byArray = pointCoDec.encodePoint(this, pointFormatter.getDefaultCompressionMethods());
            return new OCTET_STRING(byArray);
        }
        catch (ECCException eCCException) {
            throw new RuntimeException("Cannot encode coordinates " + eCCException.toString());
        }
    }

    public Coordinate toAffine() {
        return this;
    }

    public int hashCode() {
        return this.coordinateType_ + this.x_.hashCode() + this.y_.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof AffineCoordinate) {
            AffineCoordinate affineCoordinate = (AffineCoordinate)object;
            return affineCoordinate.x_.equals(this.x_) && affineCoordinate.y_.equals(this.y_);
        }
        return false;
    }

    public Object clone() {
        AffineCoordinate affineCoordinate = (AffineCoordinate)super.clone();
        affineCoordinate.x_ = (FieldElement)this.x_.clone();
        affineCoordinate.y_ = (FieldElement)this.y_.clone();
        return affineCoordinate;
    }

    public AffineCoordinate(FieldElement fieldElement, FieldElement fieldElement2) {
        super(fieldElement, fieldElement2, 0);
    }
}

