/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.math.ecgroup;

import iaik.security.ecc.math.ecgroup.BinaryAffineCurve;
import iaik.security.ecc.math.ecgroup.BinaryProjectiveCurve;
import iaik.security.ecc.math.ecgroup.CoordinateTypes;
import iaik.security.ecc.math.ecgroup.ECGroupException;
import iaik.security.ecc.math.ecgroup.ECGroupFactory;
import iaik.security.ecc.math.ecgroup.EllipticCurve;
import iaik.security.ecc.math.ecgroup.FastPrimeCurve;
import iaik.security.ecc.math.ecgroup.PrimeAffineCurve;
import iaik.security.ecc.math.ecgroup.PrimeProjectiveCurve;
import iaik.security.ecc.math.field.FieldElement;
import iaik.security.ecc.util.Utils;
import java.math.BigInteger;

class SimpleECGroupFactory
extends ECGroupFactory {
    private EllipticCurve getCurveWithProjective(FieldElement fieldElement, FieldElement fieldElement2, BigInteger bigInteger) throws ECGroupException {
        if (fieldElement.getField().getFieldId() == 1) {
            return new PrimeProjectiveCurve(fieldElement, fieldElement2, bigInteger);
        }
        if (fieldElement.getField().getFieldId() == 2) {
            return new BinaryProjectiveCurve(fieldElement, fieldElement2, bigInteger);
        }
        throw new ECGroupException("SimpleECGroupFactory.1");
    }

    private EllipticCurve getCurveWithAffine(FieldElement fieldElement, FieldElement fieldElement2, BigInteger bigInteger) throws ECGroupException {
        if (fieldElement.getField().getFieldId() == 1) {
            return new PrimeAffineCurve(fieldElement, fieldElement2, bigInteger);
        }
        if (fieldElement.getField().getFieldId() == 2) {
            return new BinaryAffineCurve(fieldElement, fieldElement2, bigInteger);
        }
        throw new ECGroupException("SimpleECGroupFactory.1");
    }

    public EllipticCurve getDefault(FieldElement fieldElement, FieldElement fieldElement2, BigInteger bigInteger) throws ECGroupException {
        return this.getCurve(fieldElement, fieldElement2, bigInteger, CoordinateTypes.getDefaultCoordinates(fieldElement.getField().getFieldId()));
    }

    public EllipticCurve getCurve(FieldElement fieldElement, FieldElement fieldElement2, BigInteger bigInteger, int n) throws ECGroupException {
        if (n == 0) {
            return this.getCurveWithAffine(fieldElement, fieldElement2, bigInteger);
        }
        if (n == 1) {
            return this.getCurveWithProjective(fieldElement, fieldElement2, bigInteger);
        }
        if (n == 2) {
            if (Utils.isSpeedUpEnabled()) {
                return new FastPrimeCurve(fieldElement, fieldElement2, bigInteger);
            }
            throw new ECGroupException("Coordinate type MIXED_COORDINATES not applicable when speed add-on not present");
        }
        throw new ECGroupException("Unknown coordinate type " + n);
    }

    SimpleECGroupFactory() {
    }
}

