/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.math.field;

import iaik.asn1.ASN1Object;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.security.ecc.math.field.BinaryField;
import iaik.security.ecc.math.field.BinaryFieldValueImpl;
import iaik.security.ecc.math.field.FieldElement;
import iaik.security.ecc.math.field.FieldException;
import iaik.security.ecc.math.field.FieldFactory;
import iaik.security.ecc.math.field.FieldImpl;
import java.math.BigInteger;

class BinaryFieldImpl
extends FieldImpl
implements BinaryField {
    protected BinaryFieldValueImpl irreducible_;
    protected BigInteger fieldSize_;
    private BinaryFieldValueImpl[] u_;
    private int[] r_;
    private static final int[] T = new int[]{0, 1, 4, 5, 16, 17, 20, 21, 64, 65, 68, 69, 80, 81, 84, 85, 256, 257, 260, 261, 272, 273, 276, 277, 320, 321, 324, 325, 336, 337, 340, 341, 1024, 1025, 1028, 1029, 1040, 1041, 1044, 1045, 1088, 1089, 1092, 1093, 1104, 1105, 1108, 1109, 1280, 1281, 1284, 1285, 1296, 1297, 1300, 1301, 1344, 1345, 1348, 1349, 1360, 1361, 1364, 1365, 4096, 4097, 4100, 4101, 4112, 4113, 4116, 4117, 4160, 4161, 4164, 4165, 4176, 4177, 4180, 4181, 4352, 4353, 4356, 4357, 4368, 4369, 4372, 4373, 4416, 4417, 4420, 4421, 4432, 4433, 4436, 4437, 5120, 5121, 5124, 5125, 5136, 5137, 5140, 5141, 5184, 5185, 5188, 5189, 5200, 5201, 5204, 5205, 5376, 5377, 5380, 5381, 5392, 5393, 5396, 5397, 5440, 5441, 5444, 5445, 5456, 5457, 5460, 5461, 16384, 16385, 16388, 16389, 16400, 16401, 16404, 16405, 16448, 16449, 16452, 16453, 16464, 16465, 16468, 16469, 16640, 16641, 16644, 16645, 16656, 16657, 16660, 16661, 16704, 16705, 16708, 16709, 16720, 16721, 16724, 16725, 17408, 17409, 17412, 17413, 17424, 17425, 17428, 17429, 17472, 17473, 17476, 17477, 17488, 17489, 17492, 17493, 17664, 17665, 17668, 17669, 17680, 17681, 17684, 17685, 17728, 17729, 17732, 17733, 17744, 17745, 17748, 17749, 20480, 20481, 20484, 20485, 20496, 20497, 20500, 20501, 20544, 20545, 20548, 20549, 20560, 20561, 20564, 20565, 20736, 20737, 20740, 20741, 20752, 20753, 20756, 20757, 20800, 20801, 20804, 20805, 20816, 20817, 20820, 20821, 21504, 21505, 21508, 21509, 21520, 21521, 21524, 21525, 21568, 21569, 21572, 21573, 21584, 21585, 21588, 21589, 21760, 21761, 21764, 21765, 21776, 21777, 21780, 21781, 21824, 21825, 21828, 21829, 21840, 21841, 21844, 21845};

    private void reduce(FieldElement fieldElement) {
        BinaryFieldValueImpl binaryFieldValueImpl = (BinaryFieldValueImpl)fieldElement.getValue();
        if (binaryFieldValueImpl.getOrder() >= this.irreducible_.getOrder()) {
            int n = this.irreducible_.getOrder();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 2 * n - 2;
            while (n5 >= n) {
                n2 = n5 / 32;
                if (binaryFieldValueImpl.polynomial_.length - 1 >= n2 && (binaryFieldValueImpl.polynomial_[n2] >> n5 & 1) == 1) {
                    n3 = (n5 - n) / 32;
                    n4 = n5 - n - 32 * n3;
                    int n6 = 0;
                    int n7 = n3;
                    while (n7 <= n3 + this.u_[n4].polynomial_.length - 1) {
                        if (n7 <= binaryFieldValueImpl.polynomial_.length - 1) {
                            int n8 = n7;
                            binaryFieldValueImpl.polynomial_[n8] = binaryFieldValueImpl.polynomial_[n8] ^ this.u_[n4].polynomial_[n6];
                        }
                        ++n6;
                        ++n7;
                    }
                }
                --n5;
            }
            int[] nArray = new int[this.irreducible_.polynomial_.length];
            System.arraycopy(binaryFieldValueImpl.polynomial_, 0, nArray, 0, this.irreducible_.polynomial_.length);
            BinaryFieldValueImpl binaryFieldValueImpl2 = new BinaryFieldValueImpl(nArray);
            int n9 = (1 << n) - 1;
            int n10 = binaryFieldValueImpl2.polynomial_.length - 1;
            binaryFieldValueImpl2.polynomial_[n10] = binaryFieldValueImpl2.polynomial_[n10] & n9;
            fieldElement.setValue(binaryFieldValueImpl2);
        }
    }

    private int getT(int n) {
        return T[n];
    }

    private BinaryFieldValueImpl[] calculateU() {
        BinaryFieldValueImpl binaryFieldValueImpl;
        BinaryFieldValueImpl[] binaryFieldValueImplArray = new BinaryFieldValueImpl[32];
        BinaryFieldValueImpl binaryFieldValueImpl2 = new BinaryFieldValueImpl(this.r_);
        int n = binaryFieldValueImpl2.getOrder();
        binaryFieldValueImplArray[0] = binaryFieldValueImpl = new BinaryFieldValueImpl(this.r_, (31 + n) / 32 + 1);
        int n2 = 1;
        while (n2 < 32) {
            binaryFieldValueImplArray[n2] = (BinaryFieldValueImpl)binaryFieldValueImplArray[n2 - 1].clone();
            binaryFieldValueImplArray[n2].shiftLeft(1);
            ++n2;
        }
        return binaryFieldValueImplArray;
    }

    private int[] calculateR() {
        int[] nArray = (int[])this.irreducible_.polynomial_.clone();
        int n = 0;
        int n2 = this.irreducible_.getOrder();
        nArray[this.irreducible_.polynomial_.length - 1] = this.irreducible_.polynomial_[this.irreducible_.polynomial_.length - 1] - (1 << n2);
        if (nArray[this.irreducible_.polynomial_.length - 1] != 0) {
            n = this.irreducible_.polynomial_.length - 1;
        } else {
            int n3 = this.irreducible_.polynomial_.length - 2;
            while (n3 >= 0) {
                if (this.irreducible_.polynomial_[n3] != 0) {
                    n = n3;
                    break;
                }
                --n3;
            }
        }
        int[] nArray2 = new int[n + 1];
        System.arraycopy(nArray, 0, nArray2, 0, n + 1);
        return nArray2;
    }

    private void add(BinaryFieldValueImpl binaryFieldValueImpl, BinaryFieldValueImpl binaryFieldValueImpl2) {
        int n = binaryFieldValueImpl.polynomial_.length;
        if (binaryFieldValueImpl2.polynomial_.length < n) {
            n = binaryFieldValueImpl2.polynomial_.length;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            binaryFieldValueImpl.polynomial_[n3] = binaryFieldValueImpl.polynomial_[n3] ^ binaryFieldValueImpl2.polynomial_[n2];
            ++n2;
        }
        binaryFieldValueImpl.updateOrder();
    }

    public String toString() {
        return this.irreducible_.toString();
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)new ObjectID("1.2.840.10045.1.2"));
        SEQUENCE sEQUENCE2 = new SEQUENCE();
        sEQUENCE2.addComponent((ASN1Object)new INTEGER(this.irreducible_.getOrder()));
        int[] nArray = null;
        try {
            nArray = this.irreducible_.getTransformed();
        }
        catch (FieldException fieldException) {
            throw new RuntimeException("Invalid irreducible polynom: expecting trinomial or pentamonial");
        }
        switch (nArray.length) {
            case 3: {
                sEQUENCE2.addComponent((ASN1Object)new ObjectID("1.2.840.10045.1.2.3.2"));
                sEQUENCE2.addComponent((ASN1Object)new INTEGER(nArray[1]));
                break;
            }
            case 5: {
                sEQUENCE2.addComponent((ASN1Object)new ObjectID("1.2.840.10045.1.2.3.3"));
                SEQUENCE sEQUENCE3 = new SEQUENCE();
                sEQUENCE3.addComponent((ASN1Object)new INTEGER(nArray[1]));
                sEQUENCE3.addComponent((ASN1Object)new INTEGER(nArray[2]));
                sEQUENCE3.addComponent((ASN1Object)new INTEGER(nArray[3]));
                sEQUENCE2.addComponent((ASN1Object)sEQUENCE3);
            }
        }
        sEQUENCE.addComponent((ASN1Object)sEQUENCE2);
        return sEQUENCE;
    }

    public void square(FieldElement fieldElement) {
        BinaryFieldValueImpl binaryFieldValueImpl = (BinaryFieldValueImpl)fieldElement.getValue().clone();
        int n = 255;
        BinaryFieldValueImpl binaryFieldValueImpl2 = new BinaryFieldValueImpl(binaryFieldValueImpl.polynomial_, binaryFieldValueImpl.polynomial_.length * 2);
        int n2 = 0;
        while (n2 < binaryFieldValueImpl.polynomial_.length) {
            int n3 = binaryFieldValueImpl.polynomial_[n2];
            binaryFieldValueImpl2.polynomial_[2 * n2] = (this.getT(n3 >> 8 & n) << 16) + this.getT(n3 & n);
            binaryFieldValueImpl2.polynomial_[2 * n2 + 1] = (this.getT(n3 >> 24 & n) << 16) + this.getT(n3 >> 16 & n);
            ++n2;
        }
        FieldElement fieldElement2 = new FieldElement(binaryFieldValueImpl2, this);
        this.reduce(fieldElement2);
        binaryFieldValueImpl2 = (BinaryFieldValueImpl)fieldElement2.getValue();
        int[] nArray = new int[this.irreducible_.polynomial_.length];
        System.arraycopy(binaryFieldValueImpl2.polynomial_, 0, nArray, 0, this.irreducible_.polynomial_.length);
        BinaryFieldValueImpl binaryFieldValueImpl3 = new BinaryFieldValueImpl(nArray);
        fieldElement.setValue(binaryFieldValueImpl3);
    }

    public FieldElement newElement(int[] nArray) {
        BinaryFieldValueImpl binaryFieldValueImpl = new BinaryFieldValueImpl(nArray);
        if (binaryFieldValueImpl.polynomial_.length < this.irreducible_.polynomial_.length) {
            int[] nArray2 = new int[this.irreducible_.polynomial_.length];
            System.arraycopy(binaryFieldValueImpl.polynomial_, 0, nArray2, 0, binaryFieldValueImpl.polynomial_.length);
            BinaryFieldValueImpl binaryFieldValueImpl2 = new BinaryFieldValueImpl(nArray2);
            return new FieldElement(binaryFieldValueImpl2, this);
        }
        return new FieldElement(binaryFieldValueImpl, this);
    }

    public FieldElement newElement(byte[] byArray) {
        int n = byArray.length >>> 2;
        int n2 = byArray.length & 3;
        int n3 = n;
        if ((byArray.length & 3) != 0) {
            ++n3;
        }
        if (n3 > this.irreducible_.polynomial_.length) {
            return null;
        }
        int[] nArray = new int[this.irreducible_.polynomial_.length];
        int n4 = 0;
        while (n4 < byArray.length) {
            int n5 = byArray[n4] & 0xFF;
            if (--n2 < 0) {
                n2 = 3;
            }
            int n6 = --n;
            nArray[n6] = nArray[n6] | n5 << (n2 << 3);
            ++n4;
        }
        BinaryFieldValueImpl binaryFieldValueImpl = new BinaryFieldValueImpl(nArray);
        return new FieldElement(binaryFieldValueImpl, this);
    }

    public void negate(FieldElement fieldElement) {
    }

    public void multiply(FieldElement fieldElement, FieldElement fieldElement2) {
        BinaryFieldValueImpl binaryFieldValueImpl = (BinaryFieldValueImpl)fieldElement.getValue();
        BinaryFieldValueImpl binaryFieldValueImpl2 = (BinaryFieldValueImpl)fieldElement2.getValue();
        int n = this.irreducible_.getOrder() >>> 5;
        int n2 = 1 << (this.irreducible_.getOrder() & 0x1F);
        int[] nArray = new int[this.irreducible_.polynomial_.length];
        BinaryFieldValueImpl binaryFieldValueImpl3 = new BinaryFieldValueImpl(nArray);
        int n3 = binaryFieldValueImpl.getOrder() >>> 5;
        int n4 = 1 << (binaryFieldValueImpl.getOrder() & 0x1F);
        int n5 = binaryFieldValueImpl.getOrder();
        while (n5 >= 0) {
            binaryFieldValueImpl3.shiftLeft(1);
            if ((binaryFieldValueImpl3.polynomial_[n] & n2) != 0) {
                this.add(binaryFieldValueImpl3, this.irreducible_);
            }
            if ((binaryFieldValueImpl.polynomial_[n3] & n4) != 0) {
                this.add(binaryFieldValueImpl3, binaryFieldValueImpl2);
            }
            if ((n4 >>>= 1) == 0) {
                --n3;
                n4 = Integer.MIN_VALUE;
            }
            --n5;
        }
        fieldElement.setValue(binaryFieldValueImpl3);
    }

    public void invert(FieldElement fieldElement) {
        int[] nArray = new int[]{1};
        BinaryFieldValueImpl binaryFieldValueImpl = new BinaryFieldValueImpl(nArray, this.irreducible_.polynomial_.length);
        nArray[0] = 0;
        BinaryFieldValueImpl binaryFieldValueImpl2 = new BinaryFieldValueImpl(nArray, this.irreducible_.polynomial_.length);
        BinaryFieldValueImpl binaryFieldValueImpl3 = (BinaryFieldValueImpl)fieldElement.getValue().clone();
        BinaryFieldValueImpl binaryFieldValueImpl4 = (BinaryFieldValueImpl)this.irreducible_.clone();
        while (binaryFieldValueImpl3.getOrder() != 0) {
            BinaryFieldValueImpl binaryFieldValueImpl5;
            int n = binaryFieldValueImpl3.getOrder() - binaryFieldValueImpl4.getOrder();
            if (n < 0) {
                binaryFieldValueImpl5 = binaryFieldValueImpl3;
                binaryFieldValueImpl3 = binaryFieldValueImpl4;
                binaryFieldValueImpl4 = binaryFieldValueImpl5;
                binaryFieldValueImpl5 = binaryFieldValueImpl;
                binaryFieldValueImpl = binaryFieldValueImpl2;
                binaryFieldValueImpl2 = binaryFieldValueImpl5;
                n = -n;
            }
            binaryFieldValueImpl5 = (BinaryFieldValueImpl)binaryFieldValueImpl4.clone();
            binaryFieldValueImpl5.shiftLeft(n);
            this.add(binaryFieldValueImpl3, binaryFieldValueImpl5);
            binaryFieldValueImpl5 = (BinaryFieldValueImpl)binaryFieldValueImpl2.clone();
            binaryFieldValueImpl5.shiftLeft(n);
            this.add(binaryFieldValueImpl, binaryFieldValueImpl5);
        }
        fieldElement.setValue(binaryFieldValueImpl);
    }

    public FieldElement getZEROelement() {
        int[] nArray = new int[this.irreducible_.polynomial_.length];
        BinaryFieldValueImpl binaryFieldValueImpl = new BinaryFieldValueImpl(nArray);
        return new FieldElement(binaryFieldValueImpl, this);
    }

    public BigInteger getSize() {
        if (this.fieldSize_ == null) {
            this.fieldSize_ = BigInteger.valueOf(2L).pow(this.irreducible_.getOrder());
        }
        return this.fieldSize_;
    }

    public int getOrder() {
        return this.irreducible_.getOrder();
    }

    public FieldElement getONEelement() {
        int[] nArray = new int[this.irreducible_.polynomial_.length];
        nArray[0] = 1;
        BinaryFieldValueImpl binaryFieldValueImpl = new BinaryFieldValueImpl(nArray);
        return new FieldElement(binaryFieldValueImpl, this);
    }

    public int[] getIrreduciblePolynomial() {
        return this.irreducible_.getPolynomial();
    }

    public int getFieldId() {
        return 2;
    }

    public void add(FieldElement fieldElement, FieldElement fieldElement2) {
        BinaryFieldValueImpl binaryFieldValueImpl = (BinaryFieldValueImpl)fieldElement.getValue();
        BinaryFieldValueImpl binaryFieldValueImpl2 = (BinaryFieldValueImpl)fieldElement2.getValue();
        this.add(binaryFieldValueImpl, binaryFieldValueImpl2);
    }

    protected BinaryFieldImpl(int[] nArray, FieldFactory fieldFactory) {
        this.irreducible_ = new BinaryFieldValueImpl(nArray);
        this.fieldFactory_ = fieldFactory;
        this.r_ = this.calculateR();
        this.u_ = this.calculateU();
    }
}

