/*
 * Decompiled with CFR 0.152.
 */
package iaik.iso.iso9796;

import iaik.iso.iso9796.ISO9796P2ParameterSpec;
import iaik.pkcs.pkcs1.MaskGenerationAlgorithm;
import iaik.utils.Util;

public class ISO9796P2S2S3ParameterSpec
extends ISO9796P2ParameterSpec {
    private MaskGenerationAlgorithm c;
    private int d = 0;
    private byte[] a;
    private int b = -1;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("Hash generation algorithm: " + (this.c == null ? "not set" : this.c.getAlgorithm()) + "\n");
        stringBuffer.append("Salt length: " + this.b + "\n");
        stringBuffer.append("Salt value: " + (this.a == null ? "not set" : Util.toString(this.a)) + "\n");
        stringBuffer.append("CMinus: " + this.d + "\n");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void setSaltLength(int n2) {
        if (this.a != null) {
            if (n2 != this.a.length) {
                throw new IllegalArgumentException("Supplied salt length does not match to salt value.");
            }
        } else if (((ISO9796P2ParameterSpec)this).c == null) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Salt length (" + n2 + ") must be not negative!");
            }
        } else if (n2 <= 0) {
            throw new IllegalArgumentException("Salt length (" + n2 + ") must be positive (> 0)!");
        }
        this.b = n2;
    }

    public void setSalt(byte[] byArray) {
        if (this.b > -1 && byArray != null && this.b != byArray.length) {
            throw new IllegalArgumentException("Length of supplied salt does not match to saltLen value.");
        }
        this.a = byArray;
        if (this.a != null) {
            this.b = this.a.length;
            return;
        }
        this.b = -1;
    }

    public void setMGFEngine(MaskGenerationAlgorithm maskGenerationAlgorithm) {
        if (maskGenerationAlgorithm == null) {
            throw new NullPointerException("MaskGenerationAlgorithm engine must not be null!");
        }
        this.c = maskGenerationAlgorithm;
    }

    public void setCMinus(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("cMinus value must not be negative!");
        }
        this.d = n2;
    }

    public int getSaltLength() {
        return this.b;
    }

    public byte[] getSalt() {
        return this.a;
    }

    public MaskGenerationAlgorithm getMGFEngine() {
        return this.c;
    }

    public int getCMinus() {
        return this.d;
    }
}

