/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuRenderer
extends SWTPartRenderer {
    private MApplication application;
    private HashMap<MMenu, ArrayList<ArrayList<MMenuElement>>> pendingCleanup = new HashMap();

    @Override
    public void init(IEclipseContext context) {
        super.init(context);
        this.application = (MApplication)context.get(MApplication.class);
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MMenu)) {
            return null;
        }
        final MMenu menuModel = (MMenu)element;
        Menu newMenu = null;
        if (parent instanceof Decorations) {
            MUIElement container = (MUIElement)((EObject)element).eContainer();
            if (container instanceof MWindow) {
                newMenu = new Menu((Decorations)parent, 2);
                newMenu.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        MenuRenderer.this.cleanUp(menuModel);
                    }
                });
            } else {
                newMenu = new Menu((Decorations)parent, 8);
            }
        } else {
            if (parent instanceof Menu) {
                int addIndex = this.calcVisibleIndex((MUIElement)menuModel);
                MenuItem newItem = new MenuItem((Menu)parent, 64, addIndex);
                this.setItemText(menuModel, newItem);
                newItem.setImage(this.getImage((MUILabel)menuModel));
                newItem.setEnabled(menuModel.isEnabled());
                return newItem;
            }
            if (parent instanceof Control) {
                newMenu = new Menu((Control)parent);
            }
        }
        return newMenu;
    }

    @Override
    public void processContents(MElementContainer<MUIElement> container) {
        Object obj;
        if (container.getChildren().size() == 0 && (obj = container.getWidget()) instanceof MenuItem) {
            MenuItem mi = (MenuItem)obj;
            if (mi.getMenu() == null) {
                mi.setMenu(new Menu(mi));
            }
            Menu menu = mi.getMenu();
            MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setText("(None Applicable)");
            menuItem.setEnabled(false);
        }
        super.processContents(container);
        obj = container.getWidget();
        MElementContainer<MUIElement> menuObj = container;
        if (obj instanceof Menu && (((Menu)obj).getStyle() & 2) != 0 && menuObj instanceof MMenu) {
            MMenu menuModel = (MMenu)menuObj;
            IEclipseContext ctx = this.getContext((MUIElement)container);
            ExpressionContext eContext = new ExpressionContext(ctx);
            ArrayList<MMenuContribution> toContribute = new ArrayList<MMenuContribution>();
            ContributionsAnalyzer.gatherMenuContributions((MMenu)menuModel, (List)this.application.getMenuContributions(), (String)menuModel.getElementId(), toContribute, (ExpressionContext)eContext, (boolean)false);
            this.addMenuBarContributions(menuModel, toContribute, ctx, eContext);
        }
    }

    private void addMenuBarContributions(final MMenu menuModel, ArrayList<MMenuContribution> toContribute, IEclipseContext ctx, final ExpressionContext eContext) {
        HashSet<String> existingMenuIds = new HashSet<String>();
        HashSet<String> existingSeparatorNames = new HashSet<String>();
        for (MMenuElement child : menuModel.getChildren()) {
            String elementId = child.getElementId();
            if (child instanceof MMenu && elementId != null) {
                existingMenuIds.add(elementId);
                continue;
            }
            if (!(child instanceof MMenuSeparator) || elementId == null) continue;
            existingSeparatorNames.add(elementId);
        }
        boolean done = toContribute.size() == 0;
        while (!done) {
            ArrayList<MMenuContribution> curList = new ArrayList<MMenuContribution>(toContribute);
            int retryCount = toContribute.size();
            toContribute.clear();
            Iterator<MMenuContribution> iterator = curList.iterator();
            while (iterator.hasNext()) {
                ArrayList<ArrayList<Object>> lists;
                final ArrayList menuContributionsToRemove = new ArrayList();
                final MMenuContribution menuContribution = iterator.next();
                if (!ContributionsAnalyzer.processAddition((MMenu)menuModel, menuContributionsToRemove, (MMenuContribution)menuContribution, existingMenuIds, existingSeparatorNames)) {
                    toContribute.add(menuContribution);
                    continue;
                }
                if (menuContribution.getVisibleWhen() != null) {
                    ctx.runAndTrack(new RunAndTrack(){

                        public boolean changed(IEclipseContext context) {
                            if (!menuModel.isToBeRendered() || !menuModel.isVisible() || menuModel.getWidget() == null) {
                                return false;
                            }
                            boolean rc = ContributionsAnalyzer.isVisible((MMenuContribution)menuContribution, (ExpressionContext)eContext);
                            for (MMenuElement element : menuContributionsToRemove) {
                                element.setToBeRendered(rc);
                            }
                            return true;
                        }
                    });
                }
                if ((lists = this.pendingCleanup.get(menuModel)) == null) {
                    lists = new ArrayList();
                    this.pendingCleanup.put(menuModel, lists);
                }
                lists.add(menuContributionsToRemove);
            }
            boolean bl = done = toContribute.size() == 0 || toContribute.size() == retryCount;
        }
    }

    private void setItemText(MMenu model, MenuItem item) {
        String text = model.getLocalizedLabel();
        if (text == null) {
            text = "";
        }
        item.setText(text);
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        Widget widget = (Widget)child.getWidget();
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
    }

    public Object getUIContainer(MUIElement element) {
        if (!(element instanceof MMenuElement)) {
            return null;
        }
        if (element.getParent().getWidget() instanceof MenuItem) {
            MenuItem mi = (MenuItem)element.getParent().getWidget();
            if (mi.getMenu() == null) {
                mi.setMenu(new Menu(mi));
            }
            return mi.getMenu();
        }
        return super.getUIContainer(element);
    }

    void cleanUp(MMenu menuModel) {
        ArrayList<ArrayList<MMenuElement>> lists = this.pendingCleanup.remove(menuModel);
        if (lists == null) {
            return;
        }
        for (ArrayList<MMenuElement> list : lists) {
            for (MMenuElement item : list) {
                menuModel.getChildren().remove(item);
            }
        }
    }
}

