/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.chunkupload.internal;

import it.sogei.rcp.chunkupload.http.HttpUpload;
import it.sogei.rcp.chunkupload.internal.Utility;
import it.sogei.rcp.chunkupload.message.Messages;
import it.sogei.rcp.chunkupload.model.FileChunkUploadBean;
import it.sogei.rcp.chunkupload.model.OpzioniChunkUploadBean;
import it.sogei.utilities.log4j.LogUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.zip.Deflater;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.Timer;

public class ChunkUploadCore {
    private OpzioniChunkUploadBean opzioni;
    private FileChunkUploadBean fileChunkUploadBean;
    private File fileIn;
    private double ctr = 0.0;
    private double etl = 0.0;
    private Timer timer;
    private final long start = new Date().getTime();
    private final SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
    private final TimeZone tz = TimeZone.getTimeZone("UTC");
    private boolean uploadEnable = true;

    public FileChunkUploadBean getFileChunkUploadBean() {
        return this.fileChunkUploadBean;
    }

    public void setFileChunkUploadBean(FileChunkUploadBean fileChunkUploadBean) {
        this.fileChunkUploadBean = fileChunkUploadBean;
    }

    public ChunkUploadCore(OpzioniChunkUploadBean opzioniIn, FileChunkUploadBean fileChunkUploadBeanIn) {
        this.opzioni = opzioniIn;
        this.fileChunkUploadBean = fileChunkUploadBeanIn;
        this.fileIn = new File(this.fileChunkUploadBean.getPath());
        LogUtil.log((String)"ChunkUploadCore ", (int)1, (String)("fileIn: " + this.fileIn.getPath()));
        this.fileChunkUploadBean.setNomeNormalizzato(this.normalizzaNomeFile(this.fileIn.getAbsolutePath()));
        LogUtil.log((String)"ChunkUploadCore ", (int)1, (String)(" nome normalizzato: " + this.fileChunkUploadBean.getNomeNormalizzato()));
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long elapsedTime = new Date().getTime() - ChunkUploadCore.this.start;
                ChunkUploadCore.this.formatter.setTimeZone(ChunkUploadCore.this.tz);
                if (Integer.parseInt(ChunkUploadCore.this.fileChunkUploadBean.getOffset()) > 0) {
                    ChunkUploadCore.this.ctr = Utility.getCurrentTrasmissionRate(Integer.parseInt(ChunkUploadCore.this.fileChunkUploadBean.getOffset()), elapsedTime);
                    ChunkUploadCore.this.etl = Utility.getEstimatedTimeLeft(Long.parseLong(ChunkUploadCore.this.fileChunkUploadBean.getSize()), Long.parseLong(ChunkUploadCore.this.fileChunkUploadBean.getOffset()), ChunkUploadCore.this.ctr);
                    String transferRate = Utility.toByteUnitsString(ChunkUploadCore.this.ctr * 1000.0);
                    ChunkUploadCore.this.fileChunkUploadBean.setCurrentTrasmissionRate(transferRate);
                    ChunkUploadCore.this.fileChunkUploadBean.setEstimatedTimeLeft(ChunkUploadCore.this.formatter.format((long)ChunkUploadCore.this.etl));
                }
            }
        });
    }

    public int upload() {
        LogUtil.log((String)"ChunkUploadCore", (int)1, (String)" - in upload()");
        this.fileChunkUploadBean.setStato("in upload...");
        int esito = 0;
        esito = this.uploadFiles();
        LogUtil.log((String)"ChunkUploadCore", (int)1, (String)(" upload() - esito: " + esito));
        this.timer.stop();
        return esito;
    }

    private int uploadFiles() {
        LogUtil.log((String)"ChunkUploadCore", (int)1, (String)" - Upload - in uploadFiles()");
        int result = 0;
        byte[] core = null;
        String messaggio = "";
        byte[] md5 = null;
        String improntaMd5 = null;
        String offset = "";
        StringBuilder stringbuffer = new StringBuilder();
        String nomeNormalizzato = null;
        File file = null;
        int i = 0;
        try {
            this.fileChunkUploadBean.setMessaggio("in upload...");
            nomeNormalizzato = this.fileChunkUploadBean.getNomeNormalizzato();
            if (nomeNormalizzato != null) {
                file = new File(this.fileChunkUploadBean.getPath());
                messaggio = "Recupero info file";
                LogUtil.log((String)"ChunkUploadCore ", (int)1, (String)messaggio);
                String dataModifica = new Date(file.lastModified()).toString();
                LogUtil.log((String)"ChunkUploadCore ", (int)1, (String)("data modifica: " + dataModifica));
                messaggio = "recupero core";
                LogUtil.log((String)"ChunkUploadCore ", (int)1, (String)messaggio);
                core = this.getCore(file);
                messaggio = "Creazione impronta";
                LogUtil.log((String)"ChunkUploadCore ", (int)1, (String)messaggio);
                stringbuffer.setLength(0);
                stringbuffer.append(nomeNormalizzato);
                stringbuffer.append(String.valueOf(file.length()));
                stringbuffer.append(dataModifica);
                int co = 0;
                while (co < core.length) {
                    stringbuffer.append(core[co]);
                    ++co;
                }
                messaggio = "Creazione digest";
                LogUtil.log((String)"ChunkUploadCore ", (int)1, (String)messaggio);
                md5 = this.getDigest(stringbuffer.toString().getBytes());
                if (md5 == null) {
                    messaggio = "Trasformazione digest in esadecimale";
                }
                LogUtil.log((String)"ChunkUploadCore ", (int)1, (String)messaggio);
                improntaMd5 = this.toHex(md5);
                LogUtil.log((String)"ChunkUploadCore ", (int)1, (String)("impronta MD5: " + improntaMd5));
                messaggio = "prima chiamata all'url di upload";
                stringbuffer.setLength(0);
                if (this.opzioni.getServlet() == 'y') {
                    stringbuffer.append("?cmd=0");
                    stringbuffer.append("&nfile=");
                    stringbuffer.append(nomeNormalizzato);
                } else if (this.opzioni.getServlet() == 'n') {
                    stringbuffer.append(nomeNormalizzato);
                    stringbuffer.append("?cmd=0");
                }
                stringbuffer.append("&hf=");
                stringbuffer.append(improntaMd5);
                stringbuffer.append("&len=");
                stringbuffer.append(String.valueOf(file.length()));
                LogUtil.log((String)"ChunkUploadCore ", (int)1, (String)(String.valueOf(messaggio) + " " + stringbuffer));
                offset = this.streamNoBody(stringbuffer.toString(), this.opzioni.getMethod());
                LogUtil.log((String)"ChunkUploadCore ", (int)1, (String)("offset " + offset));
                if (offset == null) {
                    messaggio = "l'offset \u00e8 null";
                    LogUtil.log((String)"ChunkUploadCore - Upload - ", (int)1, (String)messaggio);
                    this.fileChunkUploadBean.setMessaggio(messaggio);
                    this.fileChunkUploadBean.setStato("errore");
                    result = -2;
                }
                if (offset == "") {
                    messaggio = "il server ha risposto una stringa vuota";
                    LogUtil.log((String)"ChunkUploadCore - Upload - ", (int)1, (String)messaggio);
                    this.fileChunkUploadBean.setMessaggio(messaggio);
                    this.fileChunkUploadBean.setStato("errore");
                    result = -2;
                }
                Long.parseLong(offset);
                if (Long.parseLong(offset) >= 0L && Long.parseLong(offset) < file.length()) {
                    offset = this.streamChunk(file, this.opzioni.getMethod(), nomeNormalizzato, improntaMd5, Long.parseLong(offset), i);
                }
                if (Long.parseLong(offset) == file.length()) {
                    messaggio = "file caricato, chiamata finale";
                    LogUtil.log((String)"ChunkUploadCore - Upload - ", (int)1, (String)messaggio);
                    stringbuffer.setLength(0);
                    if (this.opzioni.getServlet() == 'y') {
                        stringbuffer.append("?cmd=2");
                        stringbuffer.append("&nfile=");
                        stringbuffer.append(nomeNormalizzato);
                    } else if (this.opzioni.getServlet() == 'n') {
                        stringbuffer.append(nomeNormalizzato);
                        stringbuffer.append("?cmd=2");
                    }
                    stringbuffer.append("&hf=");
                    stringbuffer.append(improntaMd5);
                    stringbuffer.append("&len=");
                    stringbuffer.append(String.valueOf(file.length()));
                    LogUtil.log((String)"ChunkUploadCore - Upload - ", (int)1, (String)("Ultima chiamata - url : " + stringbuffer));
                    offset = this.streamNoBody(stringbuffer.toString(), this.opzioni.getMethod());
                    if (offset.toUpperCase().equals("DONE")) {
                        messaggio = "il server ha consolidato il file " + file;
                        LogUtil.log((String)"ChunkUploadCore - Upload - ", (int)1, (String)(" cod ritorno: 0 " + messaggio));
                        this.fileChunkUploadBean.setMessaggio(messaggio);
                        result = 0;
                    }
                }
                if (offset.equals("-1")) {
                    messaggio = Messages.errore_annullamento;
                    LogUtil.log((String)"ChunkUploadCore - Upload - ", (int)1, (String)(" cod ritorno: -1 " + messaggio));
                    this.fileChunkUploadBean.setMessaggio(messaggio);
                    this.fileChunkUploadBean.setStato("errore");
                    result = -1;
                }
                if (offset.equals("-3")) {
                    messaggio = Messages.errore_connessione;
                    LogUtil.log((String)"ChunkUploadCore - Upload - ", (int)1, (String)(" cod ritorno: -3 " + messaggio));
                    this.fileChunkUploadBean.setMessaggio(messaggio);
                    this.fileChunkUploadBean.setStato("errore");
                    result = -3;
                }
                if (offset.equals("-34")) {
                    messaggio = Messages.errore_autenticazione;
                    LogUtil.log((String)"ChunkUploadCore - Upload - ", (int)1, (String)(" cod ritorno: -3 " + messaggio));
                    this.fileChunkUploadBean.setMessaggio(messaggio);
                    this.fileChunkUploadBean.setStato("errore");
                    result = -34;
                }
                if (offset.equals("-2")) {
                    messaggio = Messages.errore_upload;
                    LogUtil.log((String)"ChunkUploadCore - Upload - ", (int)1, (String)(" cod ritorno: -2 " + messaggio));
                    this.fileChunkUploadBean.setMessaggio(messaggio);
                    this.fileChunkUploadBean.setStato("errore");
                    result = -2;
                }
                if (offset.equals("-9")) {
                    messaggio = Messages.upload_cancellato;
                    LogUtil.log((String)"ChunkUploadCore - Upload - ", (int)1, (String)(" cod ritorno: -9 " + messaggio));
                    this.fileChunkUploadBean.setMessaggio(messaggio);
                    this.fileChunkUploadBean.setStato("cancellato");
                    result = -9;
                }
                if (!offset.toUpperCase().equals("DONE") && Long.parseLong(offset) > file.length()) {
                    messaggio = "il file sul server \u00e8 corrotto: offset maggiore della lunghezza del file";
                    LogUtil.log((String)"ChunkUploadCore - Upload - ", (int)1, (String)(" cod ritorno: -2 " + messaggio));
                    this.fileChunkUploadBean.setMessaggio(messaggio);
                    result = -2;
                } else if (offset.toUpperCase().equals("DONE")) {
                    messaggio = "upload completato";
                    this.fileChunkUploadBean.setMessaggio(messaggio);
                    LogUtil.log((String)"ChunkUploadCore - Upload - ", (int)1, (String)(" cod ritorno: 0 " + messaggio));
                    this.fileChunkUploadBean.setStato("upload ok");
                    result = 0;
                }
            } else {
                messaggio = Messages.errore_percorso;
                LogUtil.log((String)"ChunkUploadCore - Upload - ", (int)1, (String)(" cod ritorno: -4 " + messaggio));
                this.fileChunkUploadBean.setMessaggio(messaggio);
                this.fileChunkUploadBean.setStato("errore");
                result = -4;
            }
        }
        catch (NullPointerException np) {
            messaggio = Messages.errore_percorso;
            LogUtil.log((String)"ChunkUploadCore - Upload - ", (int)1, (String)(" cod ritorno: -4 " + messaggio));
            this.fileChunkUploadBean.setMessaggio(messaggio);
            this.fileChunkUploadBean.setStato("errore");
            result = -4;
            np.printStackTrace();
            LogUtil.log((String)"ChunkUploadCore - Upload - ", (int)1, (String)(" cod ritorno: -4 " + np.getMessage()));
        }
        catch (NumberFormatException nf) {
            this.fileChunkUploadBean.setMessaggio(Messages.errore_risposta_server);
            this.fileChunkUploadBean.setStato("errore");
            result = -5;
            nf.getMessage();
            LogUtil.log((String)"ChunkUploadCore - Upload - ", (int)1, (String)(" cod ritorno: -5 " + nf.getMessage()));
            if (this.opzioni.getDebug() > 0) {
                nf.printStackTrace();
            }
        }
        catch (Exception e) {
            messaggio = Messages.errore_generico;
            LogUtil.log((String)"ChunkUploadCore - Upload - ", (int)1, (String)(" cod ritorno: -2 " + messaggio + " - " + e.getMessage()));
            this.fileChunkUploadBean.setMessaggio(messaggio);
            this.fileChunkUploadBean.setStato("errore");
            result = -2;
            e.printStackTrace();
        }
        return result;
    }

    private byte[] getCore(File file) {
        byte[] core;
        block14: {
            RandomAccessFile raf = null;
            core = null;
            try {
                try {
                    raf = new RandomAccessFile(file.getAbsolutePath(), "r");
                    if (raf.length() <= 1024L) {
                        core = new byte[(int)raf.length()];
                        break block14;
                    }
                    core = new byte[1024];
                    raf.seek(raf.length() / 2L - 512L);
                    raf.readFully(core);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (raf != null) {
                            raf.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (raf != null) {
                        raf.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return core;
    }

    private byte[] getDigest(byte[] bytes) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(this.opzioni.getDigestAlg());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return md.digest(bytes);
    }

    private String toHex(byte[] array) {
        StringBuffer finalHash = new StringBuffer();
        int ii = 0;
        while (ii < array.length) {
            String hs;
            int v = array[ii];
            if (v < 0) {
                v += 256;
            }
            if ((hs = Integer.toHexString(v)).length() == 1) {
                hs = "0" + hs;
            }
            finalHash.append(hs);
            ++ii;
        }
        return finalHash.toString();
    }

    private String streamNoBody(String queryString, String method) {
        String offset = "";
        URL url = null;
        HttpUpload httpPut = null;
        try {
            url = new URL(String.valueOf(this.opzioni.getUploadUrl()) + queryString);
            httpPut = HttpUpload.getInstance(this.opzioni);
            offset = httpPut.connect(this.opzioni.getMethod(), this.opzioni.getRequestPropertyMap(), url);
        }
        catch (Exception e) {
            offset = "-2";
            this.fileChunkUploadBean.setStato("errore");
            e.printStackTrace();
        }
        return offset;
    }

    /*
     * Exception decompiling
     */
    private String streamChunk(File aFile, String metodo, String nomeNormalizzato, String improntaMd5, long offset, int idxInfoInvio) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] compress(byte[] buf) {
        byte[] output = new byte[buf.length];
        Deflater compresser = new Deflater();
        compresser.setInput(buf);
        compresser.finish();
        int compressedDataLength = compresser.deflate(output);
        if (compressedDataLength < buf.length) {
            byte[] bufComp = new byte[compressedDataLength];
            System.arraycopy(output, 0, bufComp, 0, compressedDataLength);
            return bufComp;
        }
        return buf;
    }

    private byte[] encrypt(byte[] buf, byte[] key, byte[] iv) {
        Cipher cipher = null;
        IvParameterSpec paramSpec = null;
        SecretKeySpec secretKeySpec = null;
        try {
            cipher = Cipher.getInstance("AES/CFB8/NoPadding");
            paramSpec = new IvParameterSpec(iv);
            secretKeySpec = new SecretKeySpec(key, "AES");
            cipher.init(1, (Key)secretKeySpec, paramSpec);
            buf = cipher.doFinal(buf);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            buf = null;
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            buf = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            buf = null;
        }
        return buf;
    }

    private String normalizzaNomeFile(String nomeFile) {
        if (nomeFile.indexOf(58) > -1) {
            nomeFile = nomeFile.substring(nomeFile.indexOf(58) + 1);
        }
        nomeFile = nomeFile.replace('\\', '/');
        while (nomeFile.startsWith("/")) {
            nomeFile = nomeFile.substring(1);
        }
        if (this.opzioni.getEncodeNomeFile() == 1) {
            try {
                nomeFile = URLEncoder.encode(nomeFile, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                LogUtil.log((String)"ChunkUploadCore ", (int)4, (String)("Errore nella codifica del nome File: " + e.getMessage()));
            }
        }
        return nomeFile;
    }

    public void stopUpload() {
        this.uploadEnable = false;
    }
}

